/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.amadron.AmadronUtil;
import me.desht.pneumaticcraft.common.amadron.ShoppingBasket;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityAmadrone;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadronAddTrade;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderResponse;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeRemoved;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkHooks;

public class ContainerAmadron
extends ContainerPneumaticBase<TileEntityBase> {
    public static final int HARD_MAX_STACKS = 36;
    public static final int HARD_MAX_MB = 576000;
    public final List<AmadronRecipe> activeOffers = new ArrayList<AmadronRecipe>(AmadronOfferManager.getInstance().getActiveOffers());
    private final ShoppingBasket shoppingBasket = new ShoppingBasket();
    private final Hand hand;
    @GuiSynced
    public final boolean[] affordableOffers = new boolean[this.activeOffers.size()];
    @GuiSynced
    public EnumProblemState problemState = EnumProblemState.NO_PROBLEMS;
    @GuiSynced
    public int maxPlayerOffers = 0;
    @GuiSynced
    public int currentPlayerOffers = 0;
    @GuiSynced
    private boolean basketEmpty = true;

    public ContainerAmadron(int windowId, PlayerInventory invPlayer, Hand hand) {
        super((ContainerType)ModContainers.AMADRON.get(), windowId, invPlayer);
        this.hand = hand;
        this.addSyncedFields(this);
        if (invPlayer.field_70458_d instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)invPlayer.field_70458_d;
            ItemStack tablet = player.func_184586_b(hand);
            ShoppingBasket savedBasket = ItemAmadronTablet.loadShoppingCart(tablet);
            ShoppingBasket availableOffers = new ShoppingBasket();
            this.activeOffers.forEach(offer -> availableOffers.setOffer(offer.func_199560_c(), Math.max(savedBasket.getUnits(offer.func_199560_c()), 1)));
            availableOffers.cap(tablet, false);
            for (int i = 0; i < this.activeOffers.size(); ++i) {
                ResourceLocation offerId = this.activeOffers.get(i).func_199560_c();
                int wantedUnits = savedBasket.getUnits(offerId);
                int availableUnits = availableOffers.getUnits(offerId);
                boolean bl = this.affordableOffers[i] = availableUnits > 0;
                if (wantedUnits <= 0 || availableUnits <= 0) continue;
                this.shoppingBasket.setOffer(offerId, Math.min(availableUnits, wantedUnits));
                Objects.requireNonNull(player.func_184102_h()).func_212871_a_((Runnable)new TickDelayedTask(player.func_184102_h().func_71259_af(), () -> NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse(offerId, availableUnits), player)));
            }
            this.basketEmpty = this.shoppingBasket.isEmpty();
            this.currentPlayerOffers = AmadronOfferManager.getInstance().countPlayerOffers(player.func_146103_bH().getId());
            this.maxPlayerOffers = PneumaticCraftUtils.isPlayerOp((PlayerEntity)player) ? Integer.MAX_VALUE : (Integer)ConfigHelper.common().amadron.maxTradesPerPlayer.get();
            this.problemState = EnumProblemState.NO_PROBLEMS;
        }
    }

    public ContainerAmadron(int windowId, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(windowId, playerInventory, buffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND);
    }

    public void updateBasket(ResourceLocation offerId, int amount) {
        this.shoppingBasket.setOffer(offerId, amount);
    }

    private void validatePurchasesCanFit() {
        AmadronOfferManager offerManager = AmadronOfferManager.getInstance();
        for (ResourceLocation offerId : this.shoppingBasket) {
            if (!offerManager.isActive(offerId)) continue;
            AmadronRecipe offer = offerManager.getOffer(offerId);
            AmadronTradeResource outputResource = offer.getOutput();
            int total = outputResource.totalSpaceRequired(this.shoppingBasket.getUnits(offerId));
            this.problemState = this.problemState.addProblem(outputResource.apply(stack -> total > 36 ? EnumProblemState.TOO_MANY_ITEMS : EnumProblemState.NO_PROBLEMS, fluidStack -> total > 576000 ? EnumProblemState.TOO_MUCH_FLUID : EnumProblemState.NO_PROBLEMS));
            if (this.problemState == EnumProblemState.NO_PROBLEMS) continue;
            return;
        }
    }

    public boolean isBasketEmpty() {
        return this.basketEmpty;
    }

    public Hand getHand() {
        return this.hand;
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        if (player.func_184586_b(this.hand).func_77973_b() == ModItems.AMADRON_TABLET.get()) {
            return player.func_184586_b(this.hand).getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                h.addAir(-1);
                if (h.getPressure() > 0.0f) {
                    return true;
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.tab.problems.notEnoughPressure"), false);
                return false;
            }).orElse(false);
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int slot) {
        return ItemStack.field_190927_a;
    }

    public void clickOffer(ResourceLocation offerId, int mouseButton, boolean shiftPressed, ServerPlayerEntity player) {
        this.problemState = EnumProblemState.NO_PROBLEMS;
        if (AmadronOfferManager.getInstance().isActive(offerId)) {
            if (mouseButton == 2) {
                this.shoppingBasket.remove(offerId);
            } else if (shiftPressed) {
                if (mouseButton == 0) {
                    this.shoppingBasket.halve(offerId);
                } else {
                    int cur = this.shoppingBasket.getUnits(offerId);
                    this.shoppingBasket.addUnitsToOffer(offerId, cur == 0 ? 1 : cur);
                }
            } else if (mouseButton == 0) {
                this.shoppingBasket.addUnitsToOffer(offerId, -1);
            } else {
                this.shoppingBasket.addUnitsToOffer(offerId, 1);
            }
            this.problemState = this.shoppingBasket.cap(player.func_184586_b(this.hand), true);
            if (this.problemState != EnumProblemState.NO_PROBLEMS) {
                this.shoppingBasket.syncToPlayer(player);
            }
            NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse(offerId, this.shoppingBasket.getUnits(offerId)), player);
            this.validatePurchasesCanFit();
        }
        this.basketEmpty = this.shoppingBasket.isEmpty();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        AmadronRecipe offer;
        super.handleGUIButtonPress(tag, shiftHeld, player);
        if (tag.equals("order")) {
            if (this.takeOrder(player, player.func_184586_b(this.hand))) {
                NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.CHIRP.get(), SoundCategory.PLAYERS, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.2f, 1.0f, false), player);
            }
        } else if (tag.equals("addPlayerTrade")) {
            this.openTradeGui(player);
        } else if (tag.startsWith("remove:") && shiftHeld && (offer = AmadronOfferManager.getInstance().getOffer(new ResourceLocation(tag.substring(7)))) instanceof AmadronPlayerOffer) {
            this.tryRemoveCustomOffer(player, (AmadronPlayerOffer)offer);
        }
    }

    private boolean takeOrder(ServerPlayerEntity player, ItemStack amadronTablet) {
        if (!(amadronTablet.func_77973_b() instanceof ItemAmadronTablet)) {
            return false;
        }
        String playerName = player.func_200200_C_().getString();
        boolean orderPlaced = false;
        for (ResourceLocation offerId : this.shoppingBasket) {
            GlobalPos fluidGPos;
            GlobalPos itemGPos;
            EntityAmadrone drone;
            AmadronRecipe offer;
            int amount = this.shoppingBasket.getUnits(offerId);
            if (!AmadronOfferManager.getInstance().isActive(offerId) || amount <= 0 || !(offer = AmadronOfferManager.getInstance().getOffer(offerId)).isUsableByPlayer((PlayerEntity)player) || (drone = ContainerAmadron.retrieveOrder(playerName, offer, amount, itemGPos = ItemAmadronTablet.getItemProvidingLocation(amadronTablet), fluidGPos = ItemAmadronTablet.getFluidProvidingLocation(amadronTablet))) == null) continue;
            drone.setHandlingOffer(offer.func_199560_c(), amount, amadronTablet, playerName, EntityAmadrone.AmadronAction.TAKING_PAYMENT);
            orderPlaced = true;
        }
        for (ResourceLocation offerId : this.shoppingBasket) {
            NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse(offerId, 0), player);
        }
        this.shoppingBasket.clear();
        this.basketEmpty = true;
        return orderPlaced;
    }

    private void openTradeGui(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return StringTextComponent.field_240750_d_;
            }

            public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ContainerAmadronAddTrade(windowId, playerInventory);
            }
        });
    }

    private void tryRemoveCustomOffer(ServerPlayerEntity player, AmadronPlayerOffer offer) {
        if (offer.isRemovableBy((PlayerEntity)player) && AmadronOfferManager.getInstance().removePlayerOffer(offer)) {
            if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeRemoval.get()).booleanValue()) {
                NetworkHandler.sendToAll(new PacketAmadronTradeRemoved(offer));
            }
            offer.returnStock();
            ItemAmadronTablet.openGui((PlayerEntity)player, this.hand);
        }
    }

    public static EntityAmadrone retrieveOrder(String playerName, AmadronRecipe offer, int units, GlobalPos itemGPos, GlobalPos liquidGPos) {
        boolean isAmadronRestock = playerName == null;
        return offer.getInput().apply(itemStack -> ContainerAmadron.retrieveOrderItems(playerName, offer, units, itemGPos, isAmadronRestock), fluidStack -> ContainerAmadron.retrieveOrderFluid(playerName, offer, units, liquidGPos, isAmadronRestock));
    }

    private static EntityAmadrone retrieveOrderItems(String playerName, AmadronRecipe offer, int units, GlobalPos itemGPos, boolean isAmadronRestock) {
        if (itemGPos == null || !ContainerAmadron.validateStockLevel(playerName, offer, units, isAmadronRestock)) {
            return null;
        }
        ItemStack queryingItems = offer.getInput().getItem();
        ItemStack[] stacks = AmadronUtil.buildStacks(queryingItems, units);
        if (stacks.length == 0) {
            Log.error(String.format("retrieveOrderItems: got empty itemstack list for offer %d x %s @ %s", units, queryingItems, itemGPos), new Object[0]);
            return null;
        }
        ContainerAmadron.reduceStockLevel(offer, units, isAmadronRestock);
        return (EntityAmadrone)DroneRegistry.getInstance().retrieveItemsAmazonStyle(itemGPos, stacks);
    }

    private static EntityAmadrone retrieveOrderFluid(String playerName, AmadronRecipe offer, int units, GlobalPos liquidGPos, boolean isAmadronRestock) {
        if (liquidGPos == null || !ContainerAmadron.validateStockLevel(playerName, offer, units, isAmadronRestock)) {
            return null;
        }
        FluidStack queryingFluid = AmadronUtil.buildFluidStack(offer.getInput().getFluid(), units);
        ContainerAmadron.reduceStockLevel(offer, units, isAmadronRestock);
        return (EntityAmadrone)DroneRegistry.getInstance().retrieveFluidAmazonStyle(liquidGPos, queryingFluid);
    }

    private static void reduceStockLevel(AmadronRecipe offer, int units, boolean isAmadronRestock) {
        if (!isAmadronRestock && (offer instanceof AmadronPlayerOffer || offer.getMaxStock() >= 0)) {
            offer.setStock(offer.getStock() - units);
            if (offer instanceof AmadronPlayerOffer) {
                AmadronPlayerOffers.save();
            }
            NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(offer.func_199560_c(), offer.getStock()));
        }
    }

    public static boolean validateStockLevel(String playerName, AmadronRecipe offer, int units, boolean isAmadronRestock) {
        if (!isAmadronRestock && offer.getStock() >= 0 && units > offer.getStock()) {
            Log.warning("ignoring suspicious order from player [%s] for %d x %s - only %d in stock right now!", playerName, units, offer, offer.getStock());
            return false;
        }
        return true;
    }

    public int getShoppingBasketUnits(ResourceLocation offerId) {
        return this.shoppingBasket.getUnits(offerId);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K && player.func_184586_b(this.hand).func_77973_b() == ModItems.AMADRON_TABLET.get()) {
            ItemAmadronTablet.saveShoppingCart(player.func_184586_b(this.hand), this.shoppingBasket);
        }
    }

    public static enum EnumProblemState implements ITranslatableEnum
    {
        NO_PROBLEMS("noProblems"),
        NO_INVENTORY("noInventory"),
        NOT_ENOUGH_ITEM_SPACE("notEnoughItemSpace"),
        NOT_ENOUGH_FLUID_SPACE("notEnoughFluidSpace"),
        NOT_ENOUGH_ITEMS("notEnoughItems"),
        NOT_ENOUGH_FLUID("notEnoughFluid"),
        OUT_OF_STOCK("outOfStock"),
        NOT_ENOUGH_STOCK("notEnoughStock"),
        TOO_MANY_ITEMS("tooManyItems"),
        TOO_MUCH_FLUID("tooMuchFluid");

        private final String locKey;

        private EnumProblemState(String locKey) {
            this.locKey = locKey;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.amadron." + this.locKey;
        }

        public EnumProblemState addProblem(EnumProblemState problem) {
            return problem == NO_PROBLEMS ? this : problem;
        }
    }
}

