/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.heat.IHeatRegistry;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicTicking;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.common.recipes.other.HeatPropertiesRecipeImpl;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public enum HeatExchangerManager implements IHeatRegistry
{
    INSTANCE;


    public static HeatExchangerManager getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public LazyOptional<IHeatExchangerLogic> getLogic(World world, BlockPos pos, Direction side) {
        return this.getLogic(world, pos, side, IHeatExchangerLogic.ALL_BLOCKS);
    }

    @Nonnull
    public LazyOptional<IHeatExchangerLogic> getLogic(World world, BlockPos pos, Direction side, BiPredicate<IWorld, BlockPos> blockFilter) {
        if (!world.isAreaLoaded(pos, 0)) {
            return LazyOptional.empty();
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side).isPresent()) {
            return te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side);
        }
        if (!blockFilter.test((IWorld)world, pos)) {
            return LazyOptional.empty();
        }
        List l = SemiblockTracker.getInstance().getAllSemiblocks(world, pos).filter(s -> s.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).isPresent()).collect(Collectors.toList());
        if (!l.isEmpty()) {
            return ((ISemiBlock)l.get(0)).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY);
        }
        if (world.func_175623_d(pos)) {
            return LazyOptional.of(() -> HeatExchangerLogicAmbient.atPosition((IWorld)world, pos));
        }
        HeatPropertiesRecipe entry = BlockHeatProperties.getInstance().getCustomHeatEntry(world, world.func_180495_p(pos));
        return entry != null ? LazyOptional.of(entry::getLogic) : LazyOptional.empty();
    }

    @Override
    public void registerBlockExchanger(Block block, double temperature, double thermalResistance) {
        BlockHeatProperties.getInstance().register(block, new HeatPropertiesRecipeImpl(block.getRegistryName(), block, (int)temperature, thermalResistance));
    }

    @Override
    public void registerHeatBehaviour(ResourceLocation id, Supplier<? extends HeatBehaviour<?>> heatBehaviour) {
        HeatBehaviourManager.getInstance().registerBehaviour(id, heatBehaviour);
    }

    @Override
    public IHeatExchangerLogic makeHeatExchangerLogic() {
        return new HeatExchangerLogicTicking();
    }
}

