/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;

public class BiomeMatcher
implements IPlayerMatcher {
    private final Set<Biome.Category> categories;

    public BiomeMatcher(Set<Biome.Category> categories) {
        this.categories = ImmutableSet.copyOf(categories);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_150787_b(this.categories.size());
        this.categories.forEach(arg_0 -> ((PacketBuffer)buffer).func_179249_a(arg_0));
    }

    @Override
    public JsonElement toJson() {
        JsonArray cats = new JsonArray();
        this.categories.forEach(cat -> cats.add(cat.name()));
        return cats;
    }

    @Override
    public void addDescription(PlayerEntity player, List<ITextComponent> tooltip) {
        if (!this.categories.isEmpty()) {
            List<ITextComponent> items = this.categories.stream().map(cat -> new StringTextComponent(cat.func_222352_a())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.biomes", new Object[0]), items);
        }
    }

    @Override
    public boolean test(PlayerEntity playerEntity) {
        return this.categories.isEmpty() || this.categories.contains(playerEntity.field_70170_p.func_226691_t_(playerEntity.func_233580_cy_()).func_201856_r());
    }

    public static class Factory
    implements IPlayerMatcher.MatcherFactory<BiomeMatcher> {
        @Override
        public BiomeMatcher fromJson(JsonElement json) {
            EnumSet<Biome.Category> categories = EnumSet.noneOf(Biome.Category.class);
            json.getAsJsonArray().forEach(element -> {
                Biome.Category cat = Biome.Category.func_235103_a_((String)element.getAsString());
                if (cat == null) {
                    throw new JsonSyntaxException("unknown biome category: " + element.getAsString());
                }
                categories.add(cat);
            });
            return new BiomeMatcher(categories);
        }

        @Override
        public BiomeMatcher fromBytes(PacketBuffer buffer) {
            EnumSet<Biome.Category> categories = EnumSet.noneOf(Biome.Category.class);
            int nCats = buffer.func_150792_a();
            for (int i = 0; i < nCats; ++i) {
                categories.add((Biome.Category)buffer.func_179257_a(Biome.Category.class));
            }
            return new BiomeMatcher(categories);
        }
    }
}

