/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.entity_tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderDroneAI;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.HackClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDroneBase;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class EntityTrackHandler {
    private static final List<Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>> trackEntries = new ArrayList<Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>>();

    public static void registerDefaultEntries() {
        IPneumaticHelmetRegistry manager = PneumaticRegistry.getInstance().getHelmetRegistry();
        manager.registerEntityTrackEntry(EntityTrackEntryLivingBase::new);
        manager.registerEntityTrackEntry(EntityTrackEntryHackable::new);
        manager.registerEntityTrackEntry(EntityTrackEntryDrone::new);
        manager.registerEntityTrackEntry(EntityTrackEntryPressurizable::new);
        manager.registerEntityTrackEntry(EntityTrackEntryAgeable::new);
        manager.registerEntityTrackEntry(EntityTrackEntryTameable::new);
        manager.registerEntityTrackEntry(EntityTrackEntryCreeper::new);
        manager.registerEntityTrackEntry(EntityTrackEntrySlime::new);
        manager.registerEntityTrackEntry(EntityTrackEntryPlayer::new);
        manager.registerEntityTrackEntry(EntityTrackEntryMob::new);
        manager.registerEntityTrackEntry(EntityTrackEntryItemFrame::new);
        manager.registerEntityTrackEntry(EntityTrackEntryPainting::new);
        manager.registerEntityTrackEntry(EntityTrackEntryMinecart::new);
    }

    public static void init() {
        for (Supplier<? extends IEntityTrackEntry> sup : PneumaticHelmetRegistry.getInstance().entityTrackEntries) {
            trackEntries.add((Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>)Pair.of(sup, (Object)sup.get()));
        }
    }

    public static List<IEntityTrackEntry> getTrackersForEntity(Entity entity) {
        ArrayList<IEntityTrackEntry> trackers = new ArrayList<IEntityTrackEntry>();
        for (Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry> pair : trackEntries) {
            if (!((IEntityTrackEntry)pair.getRight()).isApplicable(entity)) continue;
            IEntityTrackEntry newTracker = (IEntityTrackEntry)((Supplier)pair.getLeft()).get();
            newTracker.isApplicable(entity);
            trackers.add(newTracker);
        }
        return trackers;
    }

    private static ItemStack[] asItemStackArray(NonNullList<ItemStack> stacks) {
        return (ItemStack[])stacks.stream().filter(stack -> !stack.func_190926_b()).toArray(ItemStack[]::new);
    }

    public static class EntityTrackEntryItemFrame
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof ItemFrameEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            ItemFrameEntity frame = (ItemFrameEntity)entity;
            ItemStack stack = frame.func_82335_i();
            if (!stack.func_190926_b()) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.itemframe.item", stack.func_200301_q().getString()));
                if (frame.func_82333_j() != 0) {
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.itemframe.rotation", frame.func_82333_j() * 45));
                }
            }
        }
    }

    public static class EntityTrackEntryMinecart
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof AbstractMinecartEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
        }
    }

    public static class EntityTrackEntryPainting
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof PaintingEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            PaintingType art = ((PaintingEntity)entity).field_70522_e;
            if (art != null) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.painting.art", art.getRegistryName().func_110623_a()));
            }
        }
    }

    public static class EntityTrackEntryHackable
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return HackClientHandler.enabledForPlayer(ClientUtils.getClientPlayer());
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            PlayerEntity player = ClientUtils.getClientPlayer();
            IHackableEntity hackable = HackManager.getHackableForEntity(entity, player);
            if (hackable != null) {
                int hackTime = ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().entityTrackerHandler, EntityTrackerClientHandler.class).getTargetsStream().filter(target -> target.entity == entity).findFirst().map(RenderEntityTarget::getHackTime).orElse(0);
                if (hackTime == 0) {
                    if (isLookingAtTarget) {
                        hackable.addHackInfo(entity, curInfo, player);
                        HackClientHandler.addKeybindTooltip(curInfo);
                    }
                } else {
                    int requiredHackTime = hackable.getHackTime(entity, player);
                    int percentageComplete = hackTime * 100 / requiredHackTime;
                    if (percentageComplete < 100) {
                        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.hacking", percentageComplete));
                    } else if (hackTime < requiredHackTime + 20) {
                        hackable.addPostHackInfo(entity, curInfo, player);
                    } else if (isLookingAtTarget) {
                        hackable.addHackInfo(entity, curInfo, player);
                        HackClientHandler.addKeybindTooltip(curInfo);
                    }
                }
            }
        }
    }

    public static class EntityTrackEntryPlayer
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof PlayerEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            PlayerEntity player = (PlayerEntity)entity;
            EntityTrackEntryPlayer.addInventory("pneumaticcraft.entityTracker.info.player.armor", curInfo, (NonNullList<ItemStack>)player.field_71071_by.field_70460_b);
            EntityTrackEntryPlayer.addInventory("pneumaticcraft.entityTracker.info.player.holding", curInfo, (NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        }

        private static void addInventory(String key, List<ITextComponent> curInfo, NonNullList<ItemStack> stacks) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate(key, new Object[0]).func_240699_a_(TextFormatting.GRAY));
            ArrayList<ITextComponent> l = new ArrayList<ITextComponent>();
            PneumaticCraftUtils.summariseItemStacks(l, EntityTrackHandler.asItemStackArray((NonNullList<ItemStack>)stacks));
            if (l.isEmpty()) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.no_items", new Object[0]));
            } else {
                curInfo.addAll(l);
            }
        }
    }

    public static class EntityTrackEntryCreeper
    implements IEntityTrackEntry {
        private int creeperInFuseTime;

        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof CreeperEntity;
        }

        @Override
        public void update(Entity entity) {
            if (((CreeperEntity)entity).func_70832_p() == 1) {
                ++this.creeperInFuseTime;
                if (this.creeperInFuseTime > 30) {
                    this.creeperInFuseTime = 30;
                }
            } else {
                --this.creeperInFuseTime;
                if (this.creeperInFuseTime < 0) {
                    this.creeperInFuseTime = 0;
                }
            }
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            if (this.creeperInFuseTime > 0) {
                if (((CreeperEntity)entity).func_70832_p() == 1) {
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.creeper.fuse", (float)Math.round((float)(30 - this.creeperInFuseTime) / 20.0f * 10.0f) / 10.0f + "s !").func_240699_a_(TextFormatting.RED));
                } else {
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.creeper.coolDown", (float)Math.round((float)(30 - this.creeperInFuseTime) / 20.0f * 10.0f) / 10.0f + "s !").func_240699_a_(TextFormatting.DARK_GREEN));
                }
            }
        }
    }

    public static class EntityTrackEntryTameable
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof TameableEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            LivingEntity owner = ((TameableEntity)entity).func_70902_q();
            if (owner != null) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.tamed", owner.func_145748_c_().getString()));
            } else {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.canTame", new Object[0]));
            }
        }
    }

    public static class EntityTrackEntryAgeable
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof AgeableEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            int growingAge = ((AgeableEntity)entity).func_70874_b();
            if (growingAge > 0) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.canBreedIn", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(growingAge, false)));
            } else if (growingAge < 0) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.growsUpIn", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(-growingAge, false)));
            } else {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.canBreedNow", new Object[0]));
            }
        }
    }

    public static class EntityTrackEntryMob
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof MonsterEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            LivingEntity target = ((MonsterEntity)entity).func_70638_az();
            if (target != null) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.target", target.func_145748_c_().getString()));
            }
        }
    }

    public static class EntityTrackEntrySlime
    implements IEntityTrackEntry {
        private static final String[] MESSAGES = new String[]{"pneumaticcraft.entityTracker.info.slimeOther", "pneumaticcraft.entityTracker.info.slimeTiny", "pneumaticcraft.entityTracker.info.slimeSmall", "pneumaticcraft.entityTracker.info.slimeLarge"};

        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof SlimeEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            int size = ((SlimeEntity)entity).func_70809_q();
            if (size >= 1 && size <= 3) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate(MESSAGES[size], new Object[0]));
            } else {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate(MESSAGES[0], size));
            }
        }
    }

    public static class EntityTrackEntryLivingBase
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof LivingEntity;
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            int healthPercentage = (int)(((LivingEntity)entity).func_110143_aJ() / ((LivingEntity)entity).func_110138_aP() * 100.0f);
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.health", healthPercentage));
        }
    }

    public static class EntityTrackEntryPressurizable
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).isPresent();
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            float pressure = ((Float)entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).map(IAirHandler::getPressure).orElseThrow(IllegalStateException::new)).floatValue();
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(pressure, 1)));
        }
    }

    public static class EntityTrackEntryDrone
    implements IEntityTrackEntry {
        private RenderDroneAI droneAIRenderer;

        @Override
        public boolean isApplicable(Entity entity) {
            if (entity instanceof EntityDroneBase) {
                this.droneAIRenderer = new RenderDroneAI((EntityDroneBase)entity);
                return true;
            }
            return false;
        }

        public RenderDroneAI getDroneAIRenderer() {
            return this.droneAIRenderer;
        }

        @Override
        public void update(Entity entity) {
            this.droneAIRenderer.update();
        }

        @Override
        public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, Entity entity, float partialTicks) {
            this.droneAIRenderer.render(matrixStack, buffer, partialTicks);
        }

        @Override
        public void addInfo(Entity entity, List<ITextComponent> curInfo, boolean isLookingAtTarget) {
            EntityDroneBase droneBase = (EntityDroneBase)entity;
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.tamed", droneBase.getOwnerName().getString()));
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.drone.routine", droneBase.getLabel()));
            PlayerEntity player = ClientUtils.getClientPlayer();
            if (DroneDebugClientHandler.enabledForPlayer(player)) {
                ITextComponent debugKey = ClientUtils.translateKeyBind(KeyHandler.getInstance().keybindDebuggingDrone);
                if (ItemPneumaticArmor.isPlayerDebuggingDrone(player, droneBase)) {
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.drone.debugging", new Object[0]).func_240699_a_(TextFormatting.GOLD));
                    ITextComponent optionsKey = ClientUtils.translateKeyBind(KeyHandler.getInstance().keybindOpenOptions);
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.drone.debugging.key", optionsKey).func_240699_a_(TextFormatting.GOLD));
                    if (isLookingAtTarget) {
                        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.drone.stopDebugging.key", debugKey).func_240699_a_(TextFormatting.GOLD));
                    }
                } else if (isLookingAtTarget) {
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.drone.pressDebugKey", debugKey).func_240699_a_(TextFormatting.GOLD));
                }
            }
        }
    }
}

