/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;

public class RenderBlockTarget {
    private static final int SERVER_REQUEST_INTERVAL = 60;
    private static final float STAT_SCALE = 0.02f;
    private final World world;
    private final BlockPos pos;
    private final int posHash;
    private final IGuiAnimatedStat stat;
    private final PlayerEntity player;
    private final BlockTrackerClientHandler blockTracker;
    public int ticksExisted = 0;
    private int hackTime;
    private TileEntity te;
    private int nEntries;
    private boolean refreshSent = false;

    public RenderBlockTarget(World world, PlayerEntity player, BlockPos pos, TileEntity te, BlockTrackerClientHandler blockTracker) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.posHash = pos.hashCode();
        this.te = te;
        this.blockTracker = blockTracker;
        BlockState state = world.func_180495_p(pos);
        ItemStack stack = state.func_177230_c().getPickBlock(state, Minecraft.func_71410_x().field_71476_x, (IBlockReader)world, pos, player);
        ITextComponent title = stack.func_190926_b() ? PneumaticCraftUtils.xlate(world.func_180495_p(pos).func_177230_c().func_149739_a(), new Object[0]) : stack.func_200301_q();
        this.stat = new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(stack), 20, -20, HUDHandler.getInstance().getStatOverlayColor(), null, false);
        this.stat.setMinimumContractedDimensions(0, 0);
        this.stat.setAutoLineWrap(false);
    }

    public void setTileEntity(TileEntity te) {
        this.te = te;
    }

    public boolean isTargetStillValid() {
        return this.nEntries > 0;
    }

    private List<IBlockTrackEntry> getApplicableEntries() {
        return this.world.func_175667_e(this.pos) ? BlockTrackEntryList.INSTANCE.getEntriesForCoordinate((IBlockReader)this.world, this.pos, this.te) : Collections.emptyList();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void requestServerUpdate(List<IBlockTrackEntry> applicableTrackEntries) {
        for (IBlockTrackEntry entry : applicableTrackEntries) {
            entry.getServerUpdatePositions(this.te).forEach(p -> NetworkHandler.sendToServer(new PacketDescriptionPacketRequest((BlockPos)p)));
        }
        this.refreshSent = true;
    }

    public void tick() {
        if (this.te != null && this.te.func_145837_r()) {
            this.te = null;
        }
        this.stat.tickWidget();
        List<IBlockTrackEntry> applicableTrackEntries = this.getApplicableEntries();
        this.nEntries = applicableTrackEntries.size();
        if (this.isPlayerLookingAtTarget() && (!this.refreshSent || this.world.func_82737_E() % 60L == (long)(this.posHash % 60))) {
            this.requestServerUpdate(applicableTrackEntries);
        }
        if (!this.world.func_175623_d(this.pos)) {
            ArrayList<ITextComponent> textList = new ArrayList<ITextComponent>();
            if (this.ticksExisted > 120) {
                this.stat.closeStat();
                if (applicableTrackEntries.stream().anyMatch(entry -> this.blockTracker.countBlockTrackersOfType((IBlockTrackEntry)entry) <= entry.spamThreshold())) {
                    this.stat.openStat();
                }
                if (this.isPlayerLookingAtTarget()) {
                    this.stat.openStat();
                    this.addBlockTrackInfo(textList, applicableTrackEntries);
                }
            } else if (this.ticksExisted < -30) {
                this.stat.closeStat();
            }
            this.stat.setText(textList);
        }
        if (this.hackTime > 0) {
            IHackableBlock hackableBlock = HackManager.getHackableForBlock((IBlockReader)this.world, this.pos, this.player);
            this.hackTime = hackableBlock != null ? ++this.hackTime : 0;
        }
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        matrixStack.func_227860_a_();
        double x = (double)this.pos.func_177958_n() + 0.5;
        double y = (double)this.pos.func_177956_o() + 0.5;
        double z = (double)this.pos.func_177952_p() + 0.5;
        matrixStack.func_227861_a_(x, y, z);
        if (!this.world.func_175623_d(this.pos)) {
            this.renderBlockHighlight(matrixStack, buffer, this.world, this.pos, partialTicks);
        }
        RenderUtils.rotateToPlayerFacing(matrixStack);
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks) / 1.2f;
        if (this.ticksExisted > 50 && this.ticksExisted <= 120) {
            RenderProgressBar.render3d(matrixStack, buffer, 0.0, 0.4, 1.8, 0.7, 0.0, targetAcquireProgress, -788529408, -805241088);
        }
        matrixStack.func_227862_a_(0.02f, 0.02f, 0.02f);
        if (!this.world.func_175623_d(this.pos)) {
            if (this.ticksExisted > 120) {
                if (this.isPlayerLookingAtTarget()) {
                    float mul = this.getStatSizeMultiplier(MathHelper.func_76133_a((double)ClientUtils.getClientPlayer().func_70092_e(x, y, z)));
                    matrixStack.func_227862_a_(mul, mul, mul);
                    this.stat.renderStat(matrixStack, buffer, partialTicks);
                }
            } else if (this.ticksExisted > 50) {
                RenderUtils.renderString3d(I18n.func_135052_a((String)"pneumaticcraft.entityTracker.info.acquiring", (Object[])new Object[0]), 0.0f, 0.0f, -3092272, matrixStack, buffer, false, true);
                RenderUtils.renderString3d((int)targetAcquireProgress + "%", 37.0f, 24.0f, -3092272, matrixStack, buffer, false, true);
            } else if (this.ticksExisted < -30) {
                matrixStack.func_227862_a_(1.5f, 1.5f, 1.5f);
                this.stat.renderStat(matrixStack, buffer, partialTicks);
                RenderUtils.renderString3d(I18n.func_135052_a((String)"pneumaticcraft.blockTracker.info.lostTarget", (Object[])new Object[0]), 0.0f, (float)(-this.ticksExisted) / 2.5f, -65536, matrixStack, buffer, false, true);
            }
        }
        matrixStack.func_227865_b_();
    }

    private float getStatSizeMultiplier(double dist) {
        if (dist < 4.0) {
            return Math.max(0.3f, (float)(dist / 4.0));
        }
        if (dist < 10.0) {
            return 1.0f;
        }
        return (float)(dist / 10.0);
    }

    private void renderBlockHighlight(MatrixStack matrixStack, IRenderTypeBuffer buffer, World world, BlockPos pos, float partialTicks) {
        BlockState state = world.func_180495_p(pos);
        VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
        if (shape.func_197766_b()) {
            return;
        }
        float progress = ((float)(world.func_82737_E() & 0x1FL) + partialTicks) / 32.0f;
        float cycle = MathHelper.func_76126_a((float)((float)((double)progress * Math.PI)));
        float shrink = (shape == VoxelShapes.func_197868_b() ? 0.05f : 0.0f) + cycle / 60.0f;
        AxisAlignedBB aabb = shape.func_197752_a().func_186664_h((double)shrink);
        float alpha = 0.5f;
        if (this.blockTracker.getFocusedPos() != null) {
            alpha = this.blockTracker.getFocusedPos().equals((Object)pos) ? 0.75f : 0.15f;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        RenderType type = RenderUtils.renderFrame(matrixStack, buffer, aabb, 0.015625f, 0.25f, 0.75f, 0.75f, alpha, 0xF000F0, true, new Direction[0]);
        RenderUtils.finishBuffer(buffer, type);
        matrixStack.func_227865_b_();
    }

    private boolean isInitialized() {
        return this.ticksExisted >= 120;
    }

    private void addBlockTrackInfo(List<ITextComponent> textList, List<IBlockTrackEntry> entries) {
        entries.forEach(e -> e.addInformation(this.world, this.pos, this.te, this.isPlayerLookingAtTarget() ? this.blockTracker.getFocusedFace() : null, textList));
    }

    private boolean isPlayerLookingAtTarget() {
        return this.pos.equals((Object)this.blockTracker.getFocusedPos());
    }

    public void hack() {
        IHackableBlock block;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (block = HackManager.getHackableForBlock((IBlockReader)this.world, this.pos, this.player)) != null && (this.hackTime == 0 || this.hackTime > block.getHackTime((IBlockReader)this.world, this.pos, this.player))) {
            NetworkHandler.sendToServer(new PacketHackingBlockStart(this.pos));
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(InputEvent.MouseScrollEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.func_231043_a_(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
        }
        return false;
    }

    public void updateColor(int color) {
        this.stat.setBackgroundColor(color);
    }

    public ITextComponent getTitle() {
        return this.stat.getTitle();
    }
}

