/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class WidgetTemperature
extends Widget
implements ITooltipProvider {
    private int temperature;
    private int tickInterval;
    private TemperatureRange totalRange;
    private TemperatureRange operatingRange;
    private boolean drawText = true;
    private boolean showOperatingRange = true;

    public WidgetTemperature(int xIn, int yIn, TemperatureRange totalRange, int initialTemp, int tickInterval) {
        super(xIn, yIn, 13, 50, StringTextComponent.field_240750_d_);
        this.totalRange = totalRange;
        this.temperature = initialTemp;
        this.tickInterval = tickInterval;
        this.operatingRange = null;
    }

    public void setTotalRange(@Nonnull TemperatureRange totalRange) {
        this.totalRange = totalRange;
    }

    public TemperatureRange getTotalRange() {
        return this.totalRange;
    }

    public WidgetTemperature setOperatingRange(@Nullable TemperatureRange operatingRange) {
        this.operatingRange = operatingRange;
        return this;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public void setTickInterval(int tickInterval) {
        this.tickInterval = tickInterval;
    }

    public <T extends WidgetTemperature> T setDrawText(boolean drawText) {
        this.drawText = drawText;
        return (T)this;
    }

    public WidgetTemperature setShowOperatingRange(boolean showOperatingRange) {
        this.showOperatingRange = showOperatingRange;
        return this;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            RenderSystem.disableLighting();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_TEMPERATURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            WidgetTemperature.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 6), (int)this.field_230691_m_, (float)6.0f, (float)0.0f, (int)7, (int)50, (int)18, (int)50);
            int barLength = this.getYPos(this.temperature);
            WidgetTemperature.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 7), (int)(this.field_230691_m_ - 1 + this.field_230689_k_ - barLength), (float)13.0f, (float)(this.field_230689_k_ - barLength - 2), (int)5, (int)barLength, (int)18, (int)50);
            this.drawTicks(matrixStack);
            if (this.drawText) {
                GuiUtils.drawScaledText(matrixStack, Minecraft.func_71410_x().field_71466_p, TemperatureRange.TemperatureScale.CELSIUS.symbol(), this.field_230690_l_ + 7, this.field_230691_m_ + this.field_230689_k_ + 1, -12566464, 0.5f);
            }
            this.drawOperatingTempMarkers(matrixStack);
        }
    }

    public void drawTicks(MatrixStack matrixStack) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int n = 0;
        for (int tickTempC = WidgetTemperature.findNearestCelsius(this.totalRange.getMin() - 273, this.tickInterval); tickTempC <= this.totalRange.getMax() - 273; tickTempC += this.tickInterval) {
            int yOffset = this.getYPos(tickTempC + 273);
            this.func_238465_a_(matrixStack, this.field_230690_l_ + 4, this.field_230690_l_ + 6, this.field_230691_m_ - 1 + this.field_230689_k_ - yOffset, -1606401984);
            if (yOffset != 0 && yOffset != this.field_230689_k_ - 1) {
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 6, this.field_230690_l_ + 8, this.field_230691_m_ - 1 + this.field_230689_k_ - yOffset, -2134851392);
            }
            if (this.drawText && n % 2 == 0) {
                String s = Integer.toString(tickTempC);
                GuiUtils.drawScaledText(matrixStack, font, s, this.field_230690_l_ + 4 - font.func_78256_a(s) / 2, this.field_230691_m_ - 2 + this.field_230689_k_ - yOffset, -12566464, 0.5f);
            }
            ++n;
        }
    }

    public void drawOperatingTempMarkers(MatrixStack matrixStack) {
        if (this.operatingRange != null) {
            int yOffset;
            if (this.totalRange.inRange(this.operatingRange.getMax())) {
                yOffset = this.getYPos(this.operatingRange.getMax());
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 7, this.field_230690_l_ + 11, this.field_230691_m_ + 1 + this.field_230689_k_ - yOffset, -2039744);
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 9, this.field_230690_l_ + 9, this.field_230691_m_ + this.field_230689_k_ - yOffset, -2132746176);
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 8, this.field_230690_l_ + 10, this.field_230691_m_ - 1 + this.field_230689_k_ - yOffset, -2132746176);
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 7, this.field_230690_l_ + 11, this.field_230691_m_ - 2 + this.field_230689_k_ - yOffset, -2132746176);
            }
            if (this.totalRange.inRange(this.operatingRange.getMin())) {
                yOffset = this.getYPos(this.operatingRange.getMin());
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 7, this.field_230690_l_ + 11, this.field_230691_m_ - 1 + this.field_230689_k_ - yOffset, -2039744);
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 9, this.field_230690_l_ + 9, this.field_230691_m_ + this.field_230689_k_ - yOffset, -2132746176);
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 8, this.field_230690_l_ + 10, this.field_230691_m_ + 1 + this.field_230689_k_ - yOffset, -2132746176);
                this.func_238465_a_(matrixStack, this.field_230690_l_ + 7, this.field_230690_l_ + 11, this.field_230691_m_ + 2 + this.field_230689_k_ - yOffset, -2132746176);
            }
        }
    }

    private int getYPos(int temp) {
        int h = this.field_230689_k_ - 1;
        return MathHelper.func_76125_a((int)((temp - this.totalRange.getMin()) * h / (this.totalRange.getMax() - this.totalRange.getMin())), (int)0, (int)(h + 4));
    }

    private static int findNearestCelsius(int temp, int interval) {
        int q = temp % interval;
        if (q == 0) {
            return temp;
        }
        int n = temp - q;
        return Math.max(-273, n - interval);
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shift) {
        curTip.add(HeatUtil.formatHeatString(this.temperature));
        if (this.operatingRange != null && this.showOperatingRange) {
            TextFormatting tf = this.operatingRange.inRange(this.temperature) ? TextFormatting.GREEN : TextFormatting.GOLD;
            curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.requiredTemperatureString", this.operatingRange.asString(TemperatureRange.TemperatureScale.CELSIUS)).func_240699_a_(tf));
        }
    }

    public void autoScaleForTemperature() {
        if (this.temperature < 173) {
            this.setTotalRange(TemperatureRange.of(0, 275));
            this.setTickInterval(25);
        } else if (this.temperature < 273) {
            this.setTotalRange(TemperatureRange.of(123, 373));
            this.setTickInterval(25);
        } else if (this.temperature < 373) {
            this.setTotalRange(TemperatureRange.of(273, 373));
            this.setTickInterval(25);
        } else if (this.temperature < 473) {
            this.setTotalRange(TemperatureRange.of(273, 473));
            this.setTickInterval(25);
        } else if (this.temperature < 773) {
            this.setTotalRange(TemperatureRange.of(273, 773));
            this.setTickInterval(50);
        } else if (this.temperature < 1273) {
            this.setTotalRange(TemperatureRange.of(273, 1273));
            this.setTickInterval(100);
        } else {
            this.setTotalRange(TemperatureRange.of(273, 2273));
            this.setTickInterval(200);
        }
    }

    public static int roundDownK(int tempK, int interval) {
        int tempC = tempK - 273;
        int rem = tempC % interval;
        return tempK - rem;
    }

    public static int roundUpK(int tempK, int interval) {
        return WidgetTemperature.roundDownK(tempK, interval) + interval;
    }

    public static WidgetTemperature fromOperatingRange(int x, int y, TemperatureRange range) {
        TemperatureRange totalRange;
        int interval = WidgetTemperature.calcInterval(range.getMax() - range.getMin());
        if (range.hasMin() && range.hasMax()) {
            totalRange = TemperatureRange.of(WidgetTemperature.roundDownK(range.getMin(), interval), WidgetTemperature.roundUpK(range.getMax(), interval));
        } else if (range.hasMin()) {
            int minK = WidgetTemperature.roundDownK(range.getMin(), interval);
            totalRange = TemperatureRange.of(minK, minK + interval * 2);
        } else {
            totalRange = range.hasMax() ? TemperatureRange.of(0, WidgetTemperature.roundUpK(range.getMax(), interval)) : TemperatureRange.of(0, 2273);
        }
        interval = WidgetTemperature.calcInterval(totalRange.getMax() - totalRange.getMin()) * 2;
        return new WidgetTemperature(x, y, totalRange, range.getMin(), interval).setOperatingRange(range);
    }

    public static int calcInterval(int r) {
        int r1 = r / 10;
        if (r1 >= 200) {
            return 200;
        }
        if (r1 >= 100) {
            return 100;
        }
        if (r1 >= 50) {
            return 50;
        }
        if (r1 >= 15) {
            return 25;
        }
        if (r1 >= 5) {
            return 10;
        }
        return 5;
    }
}

