/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerFluxCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityFluxCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GuiFluxCompressor
extends GuiPneumaticContainerBase<ContainerFluxCompressor, TileEntityFluxCompressor> {
    private WidgetAnimatedStat inputStat;
    private WidgetTemperature tempWidget;

    public GuiFluxCompressor(ContainerFluxCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.inputStat = this.addAnimatedStat((ITextComponent)new StringTextComponent("Input"), Textures.GUI_BUILDCRAFT_ENERGY, -11184811, false);
        ((TileEntityFluxCompressor)this.te).getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> this.func_230480_a_(new WidgetEnergy(this.field_147003_i + 20, this.field_147009_r + 20, (IEnergyStorage)storage)));
        this.tempWidget = new WidgetTemperature(this.field_147003_i + 97, this.field_147009_r + 20, TemperatureRange.of(223, 673), 273, 50).setOperatingRange(TemperatureRange.of(323, 625)).setShowOperatingRange(false);
        this.func_230480_a_(this.tempWidget);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected PointXY getGaugeLocation() {
        return super.getGaugeLocation().add(10, 0);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.inputStat.setText(this.getOutputStat());
        this.tempWidget.setTemperature(((TileEntityFluxCompressor)this.te).getHeatExchanger().getTemperatureAsInt());
        this.tempWidget.autoScaleForTemperature();
    }

    private List<ITextComponent> getOutputStat() {
        ArrayList<ITextComponent> textList = new ArrayList<ITextComponent>();
        textList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.fluxCompressor.maxEnergyUsage", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        textList.add((ITextComponent)new StringTextComponent(((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() + " FE/t").func_240699_a_(TextFormatting.BLACK));
        textList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.fluxCompressor.maxInputRate", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        textList.add((ITextComponent)new StringTextComponent(((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() * 2 + " FE/t").func_240699_a_(TextFormatting.BLACK));
        textList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.fluxCompressor.storedEnergy", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        textList.add((ITextComponent)new StringTextComponent(((TileEntityFluxCompressor)this.te).getInfoEnergyStored() + " FE").func_240699_a_(TextFormatting.BLACK));
        return textList;
    }

    @Override
    protected void addPressureStatInfo(List<ITextComponent> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxProduction", PneumaticCraftUtils.roundNumberTo(((TileEntityFluxCompressor)this.te).getAirRate(), 2)));
    }

    @Override
    protected void addProblems(List<ITextComponent> textList) {
        super.addProblems(textList);
        if (((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() > ((TileEntityFluxCompressor)this.te).getInfoEnergyStored()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.fluxCompressor.noRF", new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<ITextComponent> curInfo) {
        super.addWarnings(curInfo);
        if (((TileEntityFluxCompressor)this.te).getHeatEfficiency() < 100) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.advancedAirCompressor.efficiency", ((TileEntityFluxCompressor)this.te).getHeatEfficiency() + "%"));
        }
    }
}

