/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.inventory.ContainerAerialInterface;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAerialInterface;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class GuiAerialInterface
extends GuiPneumaticContainerBase<ContainerAerialInterface, TileEntityAerialInterface> {
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[TileEntityAerialInterface.FeedMode.values().length];
    private WidgetButtonExtended xpButton;
    private WidgetAnimatedStat feedModeTab;

    public GuiAerialInterface(ContainerAerialInterface container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.interfacingRF.info.title", new Object[0]), Textures.GUI_BUILDCRAFT_ENERGY, -6282718, false).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.aerialInterface.interfacingRF.info", new Object[0]));
        ((TileEntityAerialInterface)this.te).getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> this.func_230480_a_(new WidgetEnergy(this.field_147003_i + 20, this.field_147009_r + 20, (IEnergyStorage)storage)));
        if (((TileEntityAerialInterface)this.te).dispenserUpgradeInserted) {
            List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
            if (availableXp.size() > 0) {
                WidgetAnimatedStat xpStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.liquidXp.info.title", new Object[0]), new ItemStack((IItemProvider)Items.field_151062_by), -11141291, false);
                xpStat.setText(this.getLiquidXPText()).setForegroundColor(-16777216);
                this.xpButton = new WidgetButtonExtended(20, 15, 20, 20, StringTextComponent.field_240750_d_, b -> {
                    ++((TileEntityAerialInterface)this.te).curXPFluidIndex;
                    if (((TileEntityAerialInterface)this.te).curXPFluidIndex >= availableXp.size()) {
                        ((TileEntityAerialInterface)this.te).curXPFluidIndex = -1;
                    }
                    this.setupXPButton();
                }).withTag("xpType");
                this.setupXPButton();
                xpStat.addSubWidget((Widget)this.xpButton);
                xpStat.setReservedLines(3);
            }
            this.feedModeTab = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate(((TileEntityAerialInterface)this.te).feedMode.getTranslationKey(), new Object[0]), ((TileEntityAerialInterface)this.te).feedMode.getIconStack(), -24576, false);
            this.feedModeTab.setMinimumExpandedDimensions(80, 42);
            for (int i = 0; i < TileEntityAerialInterface.FeedMode.values().length; ++i) {
                TileEntityAerialInterface.FeedMode mode = TileEntityAerialInterface.FeedMode.values()[i];
                ArrayList<ITextComponent> l = new ArrayList<ITextComponent>();
                l.add((ITextComponent)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0]).func_240699_a_(TextFormatting.YELLOW));
                l.addAll(GuiUtils.xlateAndSplit(mode.getDescTranslationKey(), new Object[0]));
                WidgetButtonExtended button = new WidgetButtonExtended(5 + 25 * i, 20, 20, 20).withTag(mode.toString()).setRenderStacks(mode.getIconStack()).setTooltipText(l);
                this.feedModeTab.addSubWidget((Widget)button);
                this.modeButtons[i] = button;
            }
            this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.interfacingFood", new Object[0]), new ItemStack((IItemProvider)Items.field_151025_P), -6250336, false).setText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.removeDispenser", new Object[0])).setForegroundColor(-16777216);
        } else {
            this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.interfacingItems", new Object[0]), new ItemStack((IItemProvider)Blocks.field_150486_ae), -6250336, false).setText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.insertDispenser", new Object[0])).setForegroundColor(-16777216);
            Arrays.fill(this.modeButtons, null);
        }
    }

    @Override
    protected boolean shouldAddSideConfigTabs() {
        return !((TileEntityAerialInterface)this.te).dispenserUpgradeInserted;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (((TileEntityAerialInterface)this.te).dispenserUpgradeInserted) {
            if (this.modeButtons[0] != null) {
                for (int i = 0; i < this.modeButtons.length; ++i) {
                    this.modeButtons[i].field_230693_o_ = ((TileEntityAerialInterface)this.te).feedMode != TileEntityAerialInterface.FeedMode.values()[i];
                }
                this.feedModeTab.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate(((TileEntityAerialInterface)this.te).feedMode.getTranslationKey(), new Object[0]));
            } else {
                this.refreshScreen();
            }
        } else if (this.modeButtons[0] != null) {
            this.refreshScreen();
        }
    }

    private void setupXPButton() {
        Fluid fluid;
        List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
        Fluid fluid2 = fluid = ((TileEntityAerialInterface)this.te).curXPFluidIndex >= 0 && ((TileEntityAerialInterface)this.te).curXPFluidIndex < availableXp.size() ? availableXp.get(((TileEntityAerialInterface)this.te).curXPFluidIndex) : Fluids.field_204541_a;
        if (fluid != Fluids.field_204541_a) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            this.xpButton.setRenderStacks(FluidUtil.getFilledBucket((FluidStack)fluidStack));
            String modName = ModNameCache.getModName(fluid.getRegistryName().func_110624_b());
            this.xpButton.setTooltipText((List<ITextComponent>)ImmutableList.of((Object)fluidStack.getDisplayName(), (Object)new StringTextComponent(modName).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.BLUE})));
        } else {
            this.xpButton.setRenderStacks(new ItemStack((IItemProvider)Items.field_151133_ar));
            this.xpButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.aerial_interface.xpDisabled", new Object[0]));
        }
    }

    private List<ITextComponent> getLiquidXPText() {
        ArrayList<ITextComponent> liquidXpText = new ArrayList<ITextComponent>(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.aerialInterface.liquidXp.info", new Object[0]));
        liquidXpText.add(StringTextComponent.field_240750_d_);
        List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
        if (availableXp.isEmpty()) {
            liquidXpText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.none", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.BLACK, TextFormatting.ITALIC}));
        } else {
            for (Fluid f : availableXp) {
                FluidStack stack = new FluidStack(f, 1000);
                String modName = ModNameCache.getModName(f.getRegistryName().func_110624_b());
                StringTextComponent modNameText = new StringTextComponent(" (" + modName + ")");
                liquidXpText.add((ITextComponent)Symbols.bullet().func_240699_a_(TextFormatting.BLACK).func_230529_a_((ITextComponent)stack.getDisplayName().func_230532_e_().func_240699_a_(TextFormatting.BLACK)).func_230529_a_((ITextComponent)modNameText.func_240699_a_(TextFormatting.DARK_BLUE)));
            }
        }
        return liquidXpText;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected void addPressureStatInfo(List<ITextComponent> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityAerialInterface)this.te).getPressure() >= ((TileEntityAerialInterface)this.te).getMinWorkingPressure() && ((TileEntityAerialInterface)this.te).isConnectedToPlayer) {
            pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.airUsage", PneumaticCraftUtils.roundNumberTo(1.0, 1)).func_240699_a_(TextFormatting.BLACK));
        }
    }

    @Override
    protected void addProblems(List<ITextComponent> textList) {
        super.addProblems(textList);
        if (((TileEntityAerialInterface)this.te).getPlayerName().isEmpty()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.aerialInterface.noPlayer", new Object[0]));
        } else if (!((TileEntityAerialInterface)this.te).isConnectedToPlayer) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.aerialInterface.playerOffline", ((TileEntityAerialInterface)this.te).getPlayerName()));
        }
    }

    @Override
    protected void addInformation(List<ITextComponent> curInfo) {
        if (((TileEntityAerialInterface)this.te).getPlayerName() != null && !((TileEntityAerialInterface)this.te).getPlayerName().isEmpty()) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.aerialInterface.linked", ((TileEntityAerialInterface)this.te).getPlayerName()));
        }
    }
}

