/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.multiblock;

import com.google.common.collect.Lists;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlueProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiBlockTracker {
    private static final Logger LOGGER = LogManager.getLogger();
    static MultiBlockTracker INSTANCE = new MultiBlockTracker();
    private List<MultiBlock> syncBlocks = new ArrayList<MultiBlock>();

    public static MultiBlockTracker get() {
        return INSTANCE;
    }

    public void addEntry(World world, BlockPos pos) {
        this.syncBlocks.add(new MultiBlock(pos, world));
    }

    public void run(World world) {
        if (world.field_72995_K) {
            return;
        }
        ArrayList helloBlocks = Lists.newArrayList();
        Iterator<MultiBlock> i = this.syncBlocks.iterator();
        while (i.hasNext()) {
            MultiBlock m = i.next();
            if (m.world != world) continue;
            helloBlocks.add(m);
            i.remove();
        }
        if (helloBlocks.isEmpty()) {
            return;
        }
        for (MultiBlock m : helloBlocks) {
            TileEntity te;
            if (!world.func_175667_e(m.pos) || !((te = world.func_175625_s(m.pos)) instanceof MultiBlockGlueProvider)) continue;
            ((MultiBlockGlueProvider)te).getGlue().onHello(world, te.func_174877_v());
        }
    }

    private static class MultiBlock {
        BlockPos pos;
        World world;

        public MultiBlock(BlockPos pos, World world) {
            this.world = world;
            this.pos = new BlockPos((Vector3i)pos);
        }
    }
}

