/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import ipsis.woot.Woot;
import ipsis.woot.advancements.ApplyPerkTrigger;
import ipsis.woot.advancements.MobCaptureTrigger;
import ipsis.woot.advancements.TierValidateTrigger;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.anvil.AnvilSetup;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.modules.fluidconvertor.FluidConvertorSetup;
import ipsis.woot.modules.generic.GenericSetup;
import ipsis.woot.modules.infuser.InfuserSetup;
import ipsis.woot.modules.layout.LayoutSetup;
import ipsis.woot.modules.oracle.OracleSetup;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.util.FakeMob;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.ConsumeItemTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.KilledTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Advancements
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public Advancements(DataGenerator dataGenerator) {
        this.generator = dataGenerator;
    }

    private Advancement registerSimpleInvAdvancement(Consumer<Advancement> consumer, String name, Advancement parent, IItemProvider itemProvider, FrameType frameType) {
        return this.register(consumer, new ResourceLocation("woot", "main/" + name), Advancement.Builder.func_200278_a().func_203905_a(parent).func_215092_a(new ItemStack(itemProvider), (ITextComponent)new TranslationTextComponent("advancements.woot." + name + ".title"), (ITextComponent)new TranslationTextComponent("advancements.woot." + name + ".description"), new ResourceLocation("textures/block/black_concrete_powder.png"), frameType, false, true, false).func_200275_a(name, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{itemProvider})));
    }

    private Advancement registerSimpleInvAdvancement(Consumer<Advancement> consumer, String name, Advancement parent, IItemProvider itemProvider) {
        return this.registerSimpleInvAdvancement(consumer, name, parent, itemProvider, FrameType.TASK);
    }

    private Advancement registerTier(Consumer<Advancement> consumer, String name, Advancement parent, IItemProvider itemProvider, Tier tier) {
        return this.register(consumer, new ResourceLocation("woot", "main/" + name), Advancement.Builder.func_200278_a().func_203905_a(parent).func_215092_a(new ItemStack(itemProvider), (ITextComponent)new TranslationTextComponent("advancements.woot." + name + ".title"), (ITextComponent)new TranslationTextComponent("advancements.woot." + name + ".description"), new ResourceLocation("textures/block/black_concrete_powder.png"), FrameType.GOAL, false, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)5)).func_200275_a(name, (ICriterionInstance)TierValidateTrigger.Instance.forTier(tier)));
    }

    private Advancement registerPerk(Consumer<Advancement> consumer, String name, Advancement parent, IItemProvider itemProvider, Perk perk) {
        return this.register(consumer, new ResourceLocation("woot", "main/" + name), Advancement.Builder.func_200278_a().func_203905_a(parent).func_215092_a(new ItemStack(itemProvider), (ITextComponent)new TranslationTextComponent("advancements.woot." + name + ".title"), (ITextComponent)new TranslationTextComponent("advancements.woot." + name + ".description"), new ResourceLocation("textures/block/black_concrete_powder.png"), FrameType.TASK, false, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)5)).func_200275_a(name, (ICriterionInstance)ApplyPerkTrigger.Instance.forPerk(perk)));
    }

    private void registerAdvancements(Consumer<Advancement> consumer) {
        Advancement root = this.register(consumer, new ResourceLocation("woot", "main/root"), Advancement.Builder.func_200278_a().func_203905_a(null).func_215092_a(new ItemStack((IItemProvider)FactorySetup.HEART_BLOCK.get()), (ITextComponent)new TranslationTextComponent("advancements.woot.root.title"), (ITextComponent)new TranslationTextComponent("advancements.woot.root.description"), new ResourceLocation("textures/block/black_concrete_powder.png"), FrameType.TASK, false, true, false).func_200275_a("killed_something", (ICriterionInstance)KilledTrigger.Instance.func_203927_c()));
        Advancement oracle = this.registerSimpleInvAdvancement(consumer, "oracle", root, (IItemProvider)OracleSetup.ORACLE_BLOCK.get());
        Advancement si_ingot = this.registerSimpleInvAdvancement(consumer, "si_ingot", root, (IItemProvider)GenericSetup.SI_INGOT_ITEM.get());
        Advancement si_anvil = this.registerSimpleInvAdvancement(consumer, "si_anvil", si_ingot, (IItemProvider)AnvilSetup.ANVIL_BLOCK.get());
        Advancement ya_hammer = this.registerSimpleInvAdvancement(consumer, "ya_hammer", si_ingot, (IItemProvider)AnvilSetup.HAMMER_ITEM.get());
        Advancement si_dust = this.registerSimpleInvAdvancement(consumer, "si_dust", ya_hammer, (IItemProvider)GenericSetup.SI_DUST_ITEM.get());
        Advancement layout = this.registerSimpleInvAdvancement(consumer, "layout", root, (IItemProvider)LayoutSetup.LAYOUT_BLOCK.get());
        Advancement intern = this.registerSimpleInvAdvancement(consumer, "intern", layout, (IItemProvider)LayoutSetup.INTERN_ITEM.get());
        Advancement shard_die = this.registerSimpleInvAdvancement(consumer, "shard_die", si_anvil, (IItemProvider)AnvilSetup.SHARD_DIE_ITEM.get());
        Advancement plate_die = this.registerSimpleInvAdvancement(consumer, "plate_die", si_anvil, (IItemProvider)AnvilSetup.PLATE_DIE_ITEM.get());
        Advancement dye_die = this.registerSimpleInvAdvancement(consumer, "dye_die", si_anvil, (IItemProvider)AnvilSetup.DYE_DIE_ITEM.get());
        Advancement si_plate = this.registerSimpleInvAdvancement(consumer, "si_plate", plate_die, (IItemProvider)GenericSetup.SI_PLATE_ITEM.get());
        Advancement casing = this.registerSimpleInvAdvancement(consumer, "casing", si_plate, (IItemProvider)GenericSetup.MACHINE_CASING_ITEM.get());
        Advancement squeezer = this.registerSimpleInvAdvancement(consumer, "squeezer", casing, (IItemProvider)SqueezerSetup.SQUEEZER_BLOCK.get());
        Advancement pure_dye = this.registerSimpleInvAdvancement(consumer, "pure_dye", squeezer, (IItemProvider)FluidSetup.PUREDYE_FLUID_BUCKET.get(), FrameType.GOAL);
        Advancement infuser = this.registerSimpleInvAdvancement(consumer, "infuser", pure_dye, (IItemProvider)InfuserSetup.INFUSER_BLOCK.get());
        Advancement prism = this.registerSimpleInvAdvancement(consumer, "prism", infuser, (IItemProvider)GenericSetup.PRISM_ITEM.get());
        Advancement magenta = this.registerSimpleInvAdvancement(consumer, "magenta", infuser, (IItemProvider)InfuserSetup.MAGENTA_DYE_PLATE_ITEM.get());
        Advancement factory_a = this.registerSimpleInvAdvancement(consumer, "factory_a", magenta, (IItemProvider)FactorySetup.FACTORY_A_BLOCK.get());
        Advancement factory_b = this.registerSimpleInvAdvancement(consumer, "factory_b", factory_a, (IItemProvider)FactorySetup.FACTORY_B_BLOCK.get());
        Advancement vat = this.registerSimpleInvAdvancement(consumer, "vat", casing, (IItemProvider)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK.get());
        Advancement purge_fluid = this.registerSimpleInvAdvancement(consumer, "purge_fluid", vat, (IItemProvider)FluidSetup.MOB_ESSENCE_FLUID_BUCKET.get());
        Advancement conatus_fluid = this.registerSimpleInvAdvancement(consumer, "conatus_fluid", purge_fluid, (IItemProvider)FluidSetup.CONATUS_FLUID_BUCKET.get(), FrameType.GOAL);
        Advancement cell_1 = this.registerSimpleInvAdvancement(consumer, "cell_1", conatus_fluid, (IItemProvider)FactorySetup.CELL_1_BLOCK.get());
        Advancement cell_2 = this.registerSimpleInvAdvancement(consumer, "cell_2", cell_1, (IItemProvider)FactorySetup.CELL_2_BLOCK.get());
        Advancement cell_3 = this.registerSimpleInvAdvancement(consumer, "cell_3", cell_2, (IItemProvider)FactorySetup.CELL_3_BLOCK.get());
        Advancement cell_4 = this.registerSimpleInvAdvancement(consumer, "cell_4", cell_3, (IItemProvider)FactorySetup.CELL_4_BLOCK.get());
        Advancement ench_squeezer = this.registerSimpleInvAdvancement(consumer, "ench_squeezer", casing, (IItemProvider)SqueezerSetup.ENCHANT_SQUEEZER_BLOCK.get());
        Advancement ench_fluid = this.registerSimpleInvAdvancement(consumer, "ench_fluid", ench_squeezer, (IItemProvider)FluidSetup.ENCHANT_FLUID_BUCKET.get());
        Advancement ench_plate_1 = this.registerSimpleInvAdvancement(consumer, "ench_plate_1", ench_fluid, (IItemProvider)GenericSetup.ENCH_PLATE_1.get());
        Advancement ench_plate_2 = this.registerSimpleInvAdvancement(consumer, "ench_plate_2", ench_fluid, (IItemProvider)GenericSetup.ENCH_PLATE_2.get());
        Advancement ench_plate_3 = this.registerSimpleInvAdvancement(consumer, "ench_plate_3", ench_fluid, (IItemProvider)GenericSetup.ENCH_PLATE_3.get());
        Advancement eff_perk_1 = this.registerPerk(consumer, "eff_perk_1", ench_plate_1, (IItemProvider)FactorySetup.EFFICIENCY_1_ITEM.get(), Perk.EFFICIENCY_1);
        Advancement head_perk_1 = this.registerPerk(consumer, "head_perk_1", ench_plate_1, (IItemProvider)FactorySetup.HEADLESS_1_ITEM.get(), Perk.HEADLESS_1);
        Advancement looting_perk_1 = this.registerPerk(consumer, "looting_perk_1", ench_plate_1, (IItemProvider)FactorySetup.LOOTING_1_ITEM.get(), Perk.LOOTING_1);
        Advancement mass_perk_1 = this.registerPerk(consumer, "mass_perk_1", ench_plate_1, (IItemProvider)FactorySetup.MASS_1_ITEM.get(), Perk.MASS_1);
        Advancement rate_perk_1 = this.registerPerk(consumer, "rate_perk_1", ench_plate_1, (IItemProvider)FactorySetup.RATE_1_ITEM.get(), Perk.RATE_1);
        Advancement shard_perk_1 = this.registerPerk(consumer, "shard_perk_1", ench_plate_1, (IItemProvider)FactorySetup.TIER_SHARD_1_ITEM.get(), Perk.TIER_SHARD_1);
        Advancement tier_1_shard = this.registerSimpleInvAdvancement(consumer, "tier_1_shard", shard_perk_1, (IItemProvider)GenericSetup.T1_SHARD_ITEM.get());
        Advancement factory_c_block = this.registerSimpleInvAdvancement(consumer, "factory_c_block", tier_1_shard, (IItemProvider)FactorySetup.FACTORY_C_BLOCK.get());
        Advancement tier_2_shard = this.registerSimpleInvAdvancement(consumer, "tier_2_shard", shard_perk_1, (IItemProvider)GenericSetup.T2_SHARD_ITEM.get());
        Advancement factory_d_block = this.registerSimpleInvAdvancement(consumer, "factory_d_block", tier_2_shard, (IItemProvider)FactorySetup.FACTORY_D_BLOCK.get());
        Advancement tier_3_shard = this.registerSimpleInvAdvancement(consumer, "tier_3_shard", shard_perk_1, (IItemProvider)GenericSetup.T3_SHARD_ITEM.get());
        Advancement factory_e_block = this.registerSimpleInvAdvancement(consumer, "factory_e_block", tier_3_shard, (IItemProvider)FactorySetup.FACTORY_E_BLOCK.get());
        Advancement xp_perk_1 = this.registerPerk(consumer, "xp_perk_1", ench_plate_1, (IItemProvider)FactorySetup.XP_1_ITEM.get(), Perk.XP_1);
        Advancement xp_shard = this.register(consumer, new ResourceLocation("woot", "main/xp_shard"), Advancement.Builder.func_200278_a().func_203905_a(xp_perk_1).func_215092_a(new ItemStack((IItemProvider)FactorySetup.XP_SHARD_ITEM.get()), (ITextComponent)new TranslationTextComponent("advancements.woot.xp_shard.title"), (ITextComponent)new TranslationTextComponent("advancements.woot.xp_shard.description"), new ResourceLocation("textures/block/black_concrete_powder.png"), FrameType.TASK, false, true, false).func_200275_a("xp_shard", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)FactorySetup.XP_SHARD_ITEM.get()))));
        Advancement xp_splinter = this.register(consumer, new ResourceLocation("woot", "main/xp_splinter"), Advancement.Builder.func_200278_a().func_203905_a(xp_perk_1).func_215092_a(new ItemStack((IItemProvider)FactorySetup.XP_SPLINTER_ITEM.get()), (ITextComponent)new TranslationTextComponent("advancements.woot.xp_splinter.title"), (ITextComponent)new TranslationTextComponent("advancements.woot.xp_splinter.description"), new ResourceLocation("textures/block/black_concrete_powder.png"), FrameType.TASK, false, true, false).func_200275_a("xp_splinter", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)FactorySetup.XP_SPLINTER_ITEM.get()))));
        Advancement slaughter = this.register(consumer, new ResourceLocation("woot", "main/slaughter"), Advancement.Builder.func_200278_a().func_203905_a(ench_plate_1).func_215092_a(new ItemStack((IItemProvider)FactorySetup.SLAUGHTER_1_ITEM.get()), (ITextComponent)new TranslationTextComponent("advancements.woot.slaughter_perk_1.title"), (ITextComponent)new TranslationTextComponent("advancements.woot.slaughter_perk_1.description"), new ResourceLocation("textures/block/black_concrete_powder.png"), FrameType.TASK, false, true, false).func_200275_a("slaughter", (ICriterionInstance)ApplyPerkTrigger.Instance.forPerk(Perk.SLAUGHTER_1)));
        Advancement crusher = this.register(consumer, new ResourceLocation("woot", "main/crusher"), Advancement.Builder.func_200278_a().func_203905_a(ench_plate_1).func_215092_a(new ItemStack((IItemProvider)FactorySetup.SLAUGHTER_1_ITEM.get()), (ITextComponent)new TranslationTextComponent("advancements.woot.crusher_perk_1.title"), (ITextComponent)new TranslationTextComponent("advancements.woot.crusher_perk_1.description"), new ResourceLocation("textures/block/black_concrete_powder.png"), FrameType.TASK, false, true, false).func_200275_a("crusher", (ICriterionInstance)ApplyPerkTrigger.Instance.forPerk(Perk.CRUSHER_1)));
        Advancement capture_mob = this.register(consumer, new ResourceLocation("woot", "main/capture_mob"), Advancement.Builder.func_200278_a().func_203905_a(shard_die).func_215092_a(new ItemStack((IItemProvider)FactorySetup.MOB_SHARD_ITEM.get()), (ITextComponent)new TranslationTextComponent("advancements.woot.capture_mob.title"), (ITextComponent)new TranslationTextComponent("advancements.woot.capture_mob.description"), new ResourceLocation("textures/block/black_concrete_powder.png"), FrameType.TASK, false, true, false).func_200275_a("capture_mob", (ICriterionInstance)MobCaptureTrigger.Instance.forMob(new FakeMob("minecraft:sheep"))));
        Advancement controller = this.registerSimpleInvAdvancement(consumer, "controller", prism, (IItemProvider)FactorySetup.CONTROLLER_BLOCK.get(), FrameType.GOAL);
        Advancement tier1 = this.registerTier(consumer, "tier1", factory_a, (IItemProvider)FactorySetup.FACTORY_A_BLOCK.get(), Tier.TIER_1);
        Advancement tier2 = this.registerTier(consumer, "tier2", factory_b, (IItemProvider)FactorySetup.CAP_A_BLOCK.get(), Tier.TIER_2);
        Advancement tier3 = this.registerTier(consumer, "tier3", factory_c_block, (IItemProvider)FactorySetup.CAP_B_BLOCK.get(), Tier.TIER_3);
        Advancement tier4 = this.registerTier(consumer, "tier4", factory_d_block, (IItemProvider)FactorySetup.CAP_C_BLOCK.get(), Tier.TIER_4);
        Advancement tier5 = this.registerTier(consumer, "tier5", factory_e_block, (IItemProvider)FactorySetup.CAP_D_BLOCK.get(), Tier.TIER_5);
    }

    private Advancement register(Consumer<Advancement> consumer, ResourceLocation resourceLocation, Advancement.Builder builder) {
        return builder.func_203904_a(consumer, resourceLocation.toString());
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path path1 = Advancements.getPath(path, advancement);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                Woot.setup.getLogger().error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        this.registerAdvancements(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Woot Advancements";
    }
}

