/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.Woot;
import ipsis.woot.crafting.FluidConvertorRecipe;
import ipsis.woot.util.FluidStackHelper;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FluidConvertorRecipeSerializer<T extends FluidConvertorRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public FluidConvertorRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"catalyst") : JSONUtils.func_152754_s((JsonObject)json, (String)"catalyst");
        Ingredient catalyst = Ingredient.func_199802_a((JsonElement)jsonelement);
        int catalystCount = 1;
        if (json.has("catalyst_count")) {
            catalystCount = JSONUtils.func_151208_a((JsonObject)json, (String)"catalyst_count", (int)1);
        }
        FluidStack inputFluid = FluidStackHelper.parse(JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
        FluidStack outputFluid = FluidStackHelper.parse(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        int energy = JSONUtils.func_151208_a((JsonObject)json, (String)"energy", (int)1000);
        return this.factory.create(recipeId, catalyst, catalystCount, inputFluid, outputFluid, energy);
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            Ingredient catalyst = Ingredient.func_199566_b((PacketBuffer)buffer);
            int catalystCount = buffer.readInt();
            FluidStack inputFluid = buffer.readFluidStack();
            FluidStack outputFluid = buffer.readFluidStack();
            int energy = buffer.readInt();
            return this.factory.create(recipeId, catalyst, catalystCount, inputFluid, outputFluid, energy);
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("FluidConvertorRecipeSerializer:read", (Throwable)e);
            throw e;
        }
    }

    public void write(PacketBuffer buffer, T recipe) {
        try {
            ((FluidConvertorRecipe)recipe).getCatalyst().func_199564_a(buffer);
            buffer.writeInt(((FluidConvertorRecipe)recipe).getCatalystCount());
            buffer.writeFluidStack(((FluidConvertorRecipe)recipe).getInputFluid());
            buffer.writeFluidStack(((FluidConvertorRecipe)recipe).getOutput());
            buffer.writeInt(((FluidConvertorRecipe)recipe).getEnergy());
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("FluidConvertorRecipeSerializer:write", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends FluidConvertorRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, int var3, FluidStack var4, FluidStack var5, int var6);
    }
}

