/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.compat.top;

import ipsis.woot.Woot;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.ControllerTileEntity;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.modules.factory.blocks.UpgradeTileEntity;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.modules.factory.layout.PatternRepository;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.modules.infuser.blocks.InfuserTileEntity;
import ipsis.woot.modules.layout.blocks.LayoutTileEntity;
import ipsis.woot.modules.squeezer.blocks.DyeSqueezerTileEntity;
import ipsis.woot.modules.squeezer.blocks.EnchantSqueezerTileEntity;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.StringHelper;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public class WootTopPlugin {
    private static boolean registered;

    public static void init() {
        if (!ModList.get().isLoaded("theoneprobe")) {
            return;
        }
        if (!registered) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> new GetTheOneProbe());
            registered = true;
        }
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Override
        @Nullable
        public Void apply(@Nullable ITheOneProbe input) {
            probe = input;
            Woot.setup.getLogger().info("Enabling support The One Probe");
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "woot:default";
                }

                public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
                    TileEntity tileEntity = world.func_175625_s(iProbeHitData.getPos());
                    if (tileEntity != null) {
                        this.addControllerProbeInfo(probeMode, iProbeInfo, tileEntity, playerEntity, blockState);
                        this.addHeartProbeInfo(probeMode, iProbeInfo, tileEntity, playerEntity, blockState);
                        this.addPerkProbeInfo(probeMode, iProbeInfo, tileEntity, playerEntity, blockState);
                        this.addDyeSqueezerProbeInfo(probeMode, iProbeInfo, tileEntity, playerEntity, blockState);
                        this.addEnchantSqueezerProbeInfo(probeMode, iProbeInfo, tileEntity, playerEntity, blockState);
                        this.addLayoutProbeInfo(probeMode, iProbeInfo, tileEntity, playerEntity, blockState);
                        this.addInfuserProbeInfo(probeMode, iProbeInfo, tileEntity, playerEntity, blockState);
                    }
                }
            });
            return null;
        }

        private void addPerkProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, TileEntity te, PlayerEntity playerEntity, BlockState blockState) {
            if (!(te instanceof UpgradeTileEntity)) {
                return;
            }
            UpgradeTileEntity upgrade = (UpgradeTileEntity)te;
            Perk perk = upgrade.getUpgrade(blockState);
            if (perk == Perk.EMPTY) {
                iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.perk.type.label") + ": "), (Object)StringHelper.translate("top.woot.perk.type.empty")));
            } else {
                iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.perk.type.label") + ": "), (Object)StringHelper.translate("item.woot." + perk.getLowerCaseName())));
            }
        }

        private void addDyeSqueezerProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, TileEntity te, PlayerEntity playerEntity, BlockState blockState) {
            if (!(te instanceof DyeSqueezerTileEntity)) {
                return;
            }
            DyeSqueezerTileEntity squeezer = (DyeSqueezerTileEntity)te;
            iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.squeezer.red.label") + ": "), (Object)StringHelper.translateFormat("top.woot.squeezer.dye.0", squeezer.getRed())));
            iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.squeezer.yellow.label") + ": "), (Object)StringHelper.translateFormat("top.woot.squeezer.dye.0", squeezer.getYellow())));
            iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.squeezer.blue.label") + ": "), (Object)StringHelper.translateFormat("top.woot.squeezer.dye.0", squeezer.getBlue())));
            iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.squeezer.white.label") + ": "), (Object)StringHelper.translateFormat("top.woot.squeezer.dye.0", squeezer.getWhite())));
            iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.squeezer.tanks.label") + ": "), (Object)(squeezer.getDumpExcess() ? StringHelper.translate("top.woot.squeezer.tanks.0") : StringHelper.translate("top.woot.squeezer.tanks.1"))));
        }

        private void addEnchantSqueezerProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, TileEntity te, PlayerEntity playerEntity, BlockState blockState) {
            if (!(te instanceof EnchantSqueezerTileEntity)) {
                return;
            }
            EnchantSqueezerTileEntity squeezer = (EnchantSqueezerTileEntity)te;
        }

        private void addInfuserProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, TileEntity te, PlayerEntity playerEntity, BlockState blockState) {
            if (!(te instanceof InfuserTileEntity)) {
                return;
            }
            InfuserTileEntity infuser = (InfuserTileEntity)te;
        }

        private void addLayoutProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, TileEntity te, PlayerEntity playerEntity, BlockState blockState) {
            PatternRepository.Pattern pattern;
            if (!(te instanceof LayoutTileEntity)) {
                return;
            }
            LayoutTileEntity layout = (LayoutTileEntity)te;
            Tier tier = layout.getTier();
            iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.layout.tier.label") + ": "), (Object)StringHelper.translate(tier.getTranslationKey())));
            if (playerEntity.func_225608_bj_() && (pattern = PatternRepository.get().getPattern(tier)) != null) {
                for (FactoryComponent component : FactoryComponent.VALUES) {
                    int count = pattern.getFactoryBlockCount(component);
                    if (count <= 0) continue;
                    String text = String.format("%2d * %s", count, StringHelper.translate(component.getTranslationKey()));
                    if (component == FactoryComponent.CELL) {
                        text = String.format("%2d * %s", count, StringHelper.translate("info.woot.intern.cell"));
                    } else if (component == FactoryComponent.CONTROLLER) {
                        text = String.format(" 1-%d * %s", count, StringHelper.translate(component.getTranslationKey()));
                    }
                    iProbeInfo.text(CompoundText.create().text(text));
                }
            }
        }

        private void addControllerProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, TileEntity te, PlayerEntity playerEntity, BlockState blockState) {
            if (!(te instanceof ControllerTileEntity)) {
                return;
            }
            ControllerTileEntity controller = (ControllerTileEntity)te;
            if (controller.getFakeMob().isValid()) {
                if (probeMode == ProbeMode.DEBUG) {
                    iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.controller.mob.label") + ": "), (Object)controller.getFakeMob().toString()));
                } else {
                    iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.controller.mob.label") + ": "), (Object)StringHelper.translate(controller.getFakeMob())));
                    iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.controller.tier.label") + ": "), (Object)StringHelper.translate(controller.getTier().getTranslationKey())));
                }
            } else {
                iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.controller.mob.label") + ":"), (Object)""));
            }
        }

        private void addHeartProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, TileEntity te, PlayerEntity playerEntity, BlockState blockState) {
            if (!(te instanceof HeartTileEntity)) {
                return;
            }
            HeartTileEntity heart = (HeartTileEntity)te;
            if (heart.isFormed()) {
                iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.heart.tier.label") + ": "), (Object)StringHelper.translate(heart.getTier().getTranslationKey())));
                for (Perk.Group group : heart.getPerks().keySet()) {
                    int level;
                    ItemStack itemStack = PerkItem.getItemStack(group, level = heart.getPerks().get((Object)group).intValue());
                    if (itemStack.func_190926_b()) continue;
                    iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.heart.perk.label") + ": "), (Object)StringHelper.translate(itemStack.func_77973_b().func_77658_a())));
                }
                Exotic exotic = heart.getExotic();
                if (exotic != Exotic.NONE) {
                    ItemStack itemStack = exotic.getItemStack();
                    iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.heart.exotic.label") + ": "), (Object)StringHelper.translate(itemStack.func_77973_b().func_77658_a())));
                }
                iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.heart.progress.label") + ": "), (Object)StringHelper.translateFormat("top.woot.heart.progress.0", heart.getProgress())));
                for (FakeMob fakeMob : heart.getFormedMobs()) {
                    iProbeInfo.text(CompoundText.createLabelInfo((String)(StringHelper.translate("top.woot.heart.mob.label") + ": "), (Object)StringHelper.translate(fakeMob)));
                }
            } else {
                iProbeInfo.text(CompoundText.create().error(StringHelper.translate("top.woot.heart.unformed")));
            }
        }
    }
}

