/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.compat.hwyla;

import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.StringHelper;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class HeartDataProvider
implements IServerDataProvider<TileEntity>,
IComponentProvider {
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        CompoundNBT nbt = accessor.getServerData();
        if (nbt != null) {
            if (nbt.func_74767_n("formed")) {
                Tier tier = Tier.byIndex(nbt.func_74762_e("tier"));
                if (tier != Tier.UNKNOWN) {
                    tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("top.woot.heart.tier.label") + ": " + StringHelper.translate(tier.getTranslationKey())));
                    for (int i = 0; i < nbt.func_74762_e("perks"); ++i) {
                        CompoundNBT nbt1 = nbt.func_74775_l("perks" + i);
                        int level = nbt1.func_74762_e("level");
                        Perk.Group group = Perk.Group.byIndex(nbt1.func_74762_e("perk"));
                        ItemStack itemStack = PerkItem.getItemStack(group, level);
                        tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("top.woot.heart.perk.label") + ": " + StringHelper.translate(itemStack.func_77973_b().func_77658_a())));
                    }
                    Exotic exotic = Exotic.getExotic(nbt.func_74762_e("exotic"));
                    if (exotic != Exotic.NONE) {
                        ItemStack itemStack = exotic.getItemStack();
                        tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("top.woot.heart.exotic.label") + ": " + StringHelper.translate(itemStack.func_77973_b().func_77658_a())));
                    }
                    int progress = nbt.func_74762_e("progress");
                    tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("top.woot.heart.progress.label") + ": " + StringHelper.translateFormat("top.woot.heart.progress.0", progress)));
                    for (int i = 0; i < nbt.func_74762_e("mobs"); ++i) {
                        CompoundNBT nbt1 = nbt.func_74775_l("mobs" + i);
                        FakeMob fakeMob = new FakeMob(nbt1);
                        tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("top.woot.heart.mob.label") + ": " + StringHelper.translate(fakeMob)));
                    }
                }
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("top.woot.heart.unformed")));
            }
        }
    }

    public void appendServerData(CompoundNBT compoundNBT, ServerPlayerEntity serverPlayerEntity, World world, TileEntity tileEntity) {
        if (tileEntity instanceof HeartTileEntity) {
            HeartTileEntity heartTileEntity = (HeartTileEntity)tileEntity;
            if (heartTileEntity.isFormed()) {
                compoundNBT.func_74757_a("formed", true);
                compoundNBT.func_74768_a("tier", heartTileEntity.getTier().ordinal());
                compoundNBT.func_74768_a("perks", heartTileEntity.getPerks().keySet().size());
                int i = 0;
                for (Perk.Group group : heartTileEntity.getPerks().keySet()) {
                    int level = heartTileEntity.getPerks().get((Object)group);
                    CompoundNBT nbt2 = new CompoundNBT();
                    nbt2.func_74768_a("level", level);
                    nbt2.func_74768_a("perk", group.ordinal());
                    compoundNBT.func_218657_a("perks" + i, (INBT)nbt2);
                    ++i;
                }
                compoundNBT.func_74768_a("exotic", heartTileEntity.getExotic().ordinal());
                compoundNBT.func_74768_a("progress", heartTileEntity.getProgress());
                compoundNBT.func_74768_a("mobs", heartTileEntity.getFormedMobs().size());
                i = 0;
                for (FakeMob fakeMob : heartTileEntity.getFormedMobs()) {
                    CompoundNBT nbt2 = new CompoundNBT();
                    FakeMob.writeToNBT(fakeMob, nbt2);
                    compoundNBT.func_218657_a("mobs" + i, (INBT)nbt2);
                    ++i;
                }
            } else {
                compoundNBT.func_74757_a("formed", false);
            }
        }
    }
}

