/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableMultipartTicking;
import org.cyclops.integrateddynamics.capability.cable.CableTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightConfig;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderPartContainer;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerConfig;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTileMultipartTicking;
import org.cyclops.integrateddynamics.client.model.CableRenderState;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class TileMultipartTicking
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile,
PartHelpers.IPartStateHolderCallback {
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> forceDisconnected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> redstoneLevels = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneInputs = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneStrong = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> lastRedstonePulses = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> lightLevels = EnumFacingMap.newMap();
    private EnumFacingMap<Integer> previousLightLevels;
    @NBTPersist
    private CompoundNBT facadeBlockTag = null;
    private final PartContainerTileMultipartTicking partContainer = new PartContainerTileMultipartTicking(this);
    private final CableTileMultipartTicking cable;
    private final INetworkCarrier networkCarrier;
    private final ICableFakeable cableFakeable;
    private IModelData cachedState = null;

    public TileMultipartTicking() {
        super(RegistryEntries.TILE_ENTITY_MULTIPART_TICKING);
        this.addCapabilityInternal(PartContainerConfig.CAPABILITY, LazyOptional.of(() -> this.partContainer));
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderPartContainer(this.partContainer)));
        this.addCapabilityInternal(FacadeableConfig.CAPABILITY, LazyOptional.of(() -> new FacadeableTileMultipartTicking(this)));
        this.cable = new CableTileMultipartTicking(this);
        this.addCapabilityInternal(CableConfig.CAPABILITY, LazyOptional.of(() -> this.cable));
        this.networkCarrier = new NetworkCarrierDefault();
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, LazyOptional.of(() -> this.networkCarrier));
        this.cableFakeable = new CableFakeableMultipartTicking(this);
        this.addCapabilityInternal(CableFakeableConfig.CAPABILITY, LazyOptional.of(() -> this.cableFakeable));
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, LazyOptional.of(() -> new PathElementTileMultipartTicking(this, (ICable)this.cable)));
        for (Direction facing : Direction.values()) {
            this.addCapabilitySided(DynamicLightConfig.CAPABILITY, facing, LazyOptional.of(() -> new DynamicLightTileMultipartTicking(this, facing)));
            this.addCapabilitySided(DynamicRedstoneConfig.CAPABILITY, facing, LazyOptional.of(() -> new DynamicRedstoneTileMultipartTicking(this, facing)));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("partContainer", (INBT)this.partContainer.serializeNBT());
        tag.func_74757_a("realCable", this.cableFakeable.isRealCable());
        return tag;
    }

    public void read(CompoundNBT tag) {
        boolean isLightTransparent;
        EnumFacingMap lastConnected = EnumFacingMap.newMap(this.connected);
        CompoundNBT lastFacadeBlock = this.facadeBlockTag;
        boolean lastRealCable = this.cableFakeable.isRealCable();
        this.partContainer.deserializeNBT(tag.func_74775_l("partContainer"));
        boolean wasLightTransparent = this.func_145831_w() != null && CableHelpers.isLightTransparent((IBlockReader)this.func_145831_w(), this.func_174877_v(), null);
        super.read(tag);
        this.cableFakeable.setRealCable(tag.func_74767_n("realCable"));
        boolean bl = isLightTransparent = this.func_145831_w() != null && CableHelpers.isLightTransparent((IBlockReader)this.func_145831_w(), this.func_174877_v(), null);
        if (!(this.func_145831_w() == null || lastConnected != null && this.connected != null && lastConnected.equals(this.connected) && Objects.equals(lastFacadeBlock, this.facadeBlockTag) && lastRealCable == this.cableFakeable.isRealCable() && wasLightTransparent == isLightTransparent)) {
            BlockHelpers.markForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        }
    }

    public void onUpdateReceived() {
        if (!this.lightLevels.equals(this.previousLightLevels)) {
            this.previousLightLevels = this.lightLevels;
        }
        this.cachedState = null;
        BlockHelpers.markForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    public IModelData getConnectionState() {
        if (this.cachedState != null) {
            return this.cachedState;
        }
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        if (this.partContainer.getPartData() != null) {
            builder.withInitial(BlockCable.REALCABLE, (Object)this.cableFakeable.isRealCable());
            if (this.connected.isEmpty()) {
                this.getCable().updateConnections();
            }
            for (Direction side : Direction.values()) {
                builder.withInitial(BlockCable.CONNECTED[side.ordinal()], (Object)(!this.cable.isForceDisconnected(side) && (Boolean)this.connected.get((Object)side) != false ? 1 : 0));
                builder.withInitial(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)(this.partContainer.hasPart(side) ? this.partContainer.getPart(side).getPartRenderPosition() : PartRenderPosition.NONE));
            }
            IFacadeable facadeable = (IFacadeable)this.getCapability(FacadeableConfig.CAPABILITY).orElse(null);
            builder.withInitial(BlockCable.FACADE, facadeable.hasFacade() ? Optional.of(facadeable.getFacade()) : Optional.empty());
            builder.withInitial(BlockCable.PARTCONTAINER, (Object)this.partContainer);
            builder.withInitial(BlockCable.RENDERSTATE, (Object)new CableRenderState(this.cableFakeable.isRealCable(), (EnumFacingMap<Boolean>)EnumFacingMap.newMap(this.connected), EnumFacingMap.newMap(this.partContainer.getPartData()), (INBT)this.facadeBlockTag));
        }
        this.cachedState = builder.build();
        return this.cachedState;
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.connected.isEmpty()) {
            this.cable.updateConnections();
        }
        this.partContainer.update();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K && this.getNetwork() == null) {
            NetworkHelpers.revalidateNetworkElements(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void updateRedstoneInfo(Direction side, boolean strongPower) {
        this.func_70296_d();
        if (this.func_145831_w().func_175667_e(this.func_174877_v().func_177972_a(side))) {
            this.func_145831_w().func_190524_a(this.func_174877_v().func_177972_a(side), this.func_195044_w().func_177230_c(), this.func_174877_v());
            if (strongPower) {
                this.func_145831_w().func_195593_d(this.func_174877_v().func_177972_a(side), this.func_195044_w().func_177230_c());
            }
        }
    }

    public void updateLightInfo() {
        this.sendUpdate();
    }

    public INetwork getNetwork() {
        return this.networkCarrier.getNetwork();
    }

    @Override
    public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
    }

    public EnumFacingMap<Boolean> getForceDisconnected() {
        return this.forceDisconnected;
    }

    public void setForceDisconnected(EnumFacingMap<Boolean> forceDisconnected) {
        this.forceDisconnected.clear();
        this.forceDisconnected.putAll(forceDisconnected);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        LazyOptional value = super.getCapability(capability, facing);
        if (value.isPresent()) {
            return value;
        }
        return this.partContainer.getCapability(capability, facing);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.invalidateParts();
    }

    protected void invalidateParts() {
        INetwork network;
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K && (network = this.getNetwork()) != null) {
            for (Map.Entry entry : this.partContainer.getPartData().entrySet()) {
                INetworkElement element = ((PartHelpers.PartStateHolder)entry.getValue()).getPart().createNetworkElement(this.getPartContainer(), DimPos.of((World)this.func_145831_w(), (BlockPos)this.func_174877_v()), (Direction)entry.getKey());
                element.invalidate(network);
            }
        }
    }

    protected Direction transformFacingForRotation(Direction facing) {
        return facing;
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public EnumFacingMap<Integer> getRedstoneLevels() {
        return this.redstoneLevels;
    }

    public EnumFacingMap<Boolean> getRedstoneInputs() {
        return this.redstoneInputs;
    }

    public EnumFacingMap<Boolean> getRedstoneStrong() {
        return this.redstoneStrong;
    }

    public EnumFacingMap<Integer> getLastRedstonePulses() {
        return this.lastRedstonePulses;
    }

    public EnumFacingMap<Integer> getLightLevels() {
        return this.lightLevels;
    }

    public CompoundNBT getFacadeBlockTag() {
        return this.facadeBlockTag;
    }

    public void setFacadeBlockTag(CompoundNBT facadeBlockTag) {
        this.facadeBlockTag = facadeBlockTag;
    }

    public PartContainerTileMultipartTicking getPartContainer() {
        return this.partContainer;
    }

    public CableTileMultipartTicking getCable() {
        return this.cable;
    }

    public INetworkCarrier getNetworkCarrier() {
        return this.networkCarrier;
    }

    public ICableFakeable getCableFakeable() {
        return this.cableFakeable;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

