/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSerializerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeSerializerMechanicalSqueezer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RecipeMechanicalSqueezer> {
    public RecipeMechanicalSqueezer read(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)true);
        NonNullList<RecipeSqueezer.ItemStackChance> outputItemStacks = RecipeSerializerSqueezer.getJsonItemStackChances(result, "items");
        FluidStack outputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)result, (String)"fluid", (boolean)false);
        int duration = JSONUtils.func_151203_m((JsonObject)json, (String)"duration");
        if (inputIngredient.func_203189_d()) {
            throw new JsonSyntaxException("An input item is required");
        }
        if (outputItemStacks.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeMechanicalSqueezer(recipeId, inputIngredient, outputItemStacks, outputFluid, duration);
    }

    @Nullable
    public RecipeMechanicalSqueezer read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient inputIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        NonNullList outputItemStacks = NonNullList.func_191196_a();
        int outputItemStacksCount = buffer.readInt();
        for (int i = 0; i < outputItemStacksCount; ++i) {
            outputItemStacks.add((Object)new RecipeSqueezer.ItemStackChance(buffer.func_150791_c(), buffer.readFloat()));
        }
        FluidStack outputFluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        int duration = buffer.func_150792_a();
        return new RecipeMechanicalSqueezer(recipeId, inputIngredient, (NonNullList<RecipeSqueezer.ItemStackChance>)outputItemStacks, outputFluid, duration);
    }

    public void write(PacketBuffer buffer, RecipeMechanicalSqueezer recipe) {
        recipe.getInputIngredient().func_199564_a(buffer);
        buffer.writeInt(recipe.getOutputItems().size());
        for (RecipeSqueezer.ItemStackChance outputItem : recipe.getOutputItems()) {
            buffer.func_150788_a(outputItem.getItemStack());
            buffer.writeFloat(outputItem.getChance());
        }
        recipe.getOutputFluid().writeToPacket(buffer);
        buffer.func_150787_b(recipe.getDuration());
    }
}

