/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.util.Direction;

public class DirectionUtils {
    public static final Direction[] VALUES = Direction.values();
    public static final Direction[] BY_HORIZONTAL_INDEX = (Direction[])Arrays.stream(VALUES).filter(direction -> direction.func_176740_k().func_176722_c()).sorted(Comparator.comparingInt(Direction::func_176736_b)).toArray(Direction[]::new);

    public static Direction rotateAround(Direction d, Direction.Axis axis) {
        switch (axis) {
            case X: {
                if (d != Direction.WEST && d != Direction.EAST) {
                    return DirectionUtils.rotateX(d);
                }
                return d;
            }
            case Y: {
                if (d != Direction.UP && d != Direction.DOWN) {
                    return d.func_176746_e();
                }
                return d;
            }
            case Z: {
                if (d != Direction.NORTH && d != Direction.SOUTH) {
                    return DirectionUtils.rotateZ(d);
                }
                return d;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    public static Direction rotateX(Direction d) {
        switch (d) {
            case NORTH: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + d);
            }
            case SOUTH: {
                return Direction.UP;
            }
            case UP: {
                return Direction.NORTH;
            }
            case DOWN: 
        }
        return Direction.SOUTH;
    }

    public static Direction rotateZ(Direction d) {
        switch (d) {
            case EAST: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + d);
            }
            case WEST: {
                return Direction.UP;
            }
            case UP: {
                return Direction.EAST;
            }
            case DOWN: 
        }
        return Direction.WEST;
    }
}

