/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class AutoWorkbenchTileEntity
extends PoweredMultiblockTileEntity<AutoWorkbenchTileEntity, MultiblockRecipe>
implements IEBlockInterfaces.IInteractionObjectIE,
ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
    public int selectedRecipe = -1;
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forTileEntityAt(this, this::getOutputPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new IEInventoryHandler(16, (IIEInventory)this, 1, true, false));

    public AutoWorkbenchTileEntity() {
        super(IEMultiblocks.AUTO_WORKBENCH, 32000, true, (TileEntityType)IETileTypes.AUTO_WORKBENCH.get());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.selectedRecipe = nbt.func_74762_e("selectedRecipe");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 17);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("selectedRecipe", this.selectedRecipe);
        nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        if (message.func_150297_b("recipe", 3)) {
            this.selectedRecipe = message.func_74762_e("recipe");
        }
    }

    @Override
    public void func_73660_a() {
        BlueprintCraftingRecipe recipe;
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 16L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xF) || ((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return;
        }
        BlueprintCraftingRecipe[] recipes = this.getAvailableRecipes();
        if (recipes.length > 0 && this.selectedRecipe >= 0 && this.selectedRecipe < recipes.length && (recipe = recipes[this.selectedRecipe]) != null && !recipe.output.func_190926_b()) {
            NonNullList query = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < query.size(); ++i) {
                query.set(i, (Object)((ItemStack)this.inventory.get(i + 1)));
            }
            int crafted = recipe.getMaxCrafted((NonNullList<ItemStack>)query);
            if (crafted > 0 && this.addProcessToQueue(new PoweredMultiblockTileEntity.MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, (NonNullList<ItemStack>)NonNullList.func_191196_a()), true)) {
                this.addProcessToQueue(new PoweredMultiblockTileEntity.MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, recipe.consumeInputs((NonNullList<ItemStack>)query, 1)), false);
                for (int i = 0; i < query.size(); ++i) {
                    this.inventory.set(i + 1, (Object)((ItemStack)query.get(i)));
                }
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    public BlueprintCraftingRecipe[] getAvailableRecipes() {
        return EngineersBlueprintItem.getRecipes((ItemStack)this.inventory.get(0));
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        ImmutableSet highFullBlocks = ImmutableSet.of((Object)new BlockPos(0, 1, 2), (Object)new BlockPos(0, 1, 1));
        if (this.posInMultiblock.func_177956_o() == 0 || highFullBlocks.contains(this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        ImmutableSet conveyors = ImmutableSet.of((Object)new BlockPos(1, 1, 1), (Object)new BlockPos(2, 1, 1), (Object)new BlockPos(0, 1, 0), (Object)new BlockPos(1, 1, 0));
        if (conveyors.contains(this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (ImmutableSet.of((Object)new BlockPos(1, 1, 2), (Object)new BlockPos(2, 1, 2)).contains((Object)this.posInMultiblock)) {
            boolean is11 = new BlockPos(2, 1, 2).equals((Object)this.posInMultiblock);
            yMax = 0.8125f;
            if (this.getFacing() == Direction.NORTH) {
                zMin = 0.1875f;
                if (is11) {
                    xMax = 0.875f;
                }
            } else if (this.getFacing() == Direction.SOUTH) {
                zMax = 0.8125f;
                if (is11) {
                    xMin = 0.125f;
                }
            } else if (this.getFacing() == Direction.WEST) {
                xMin = 0.1875f;
                if (is11) {
                    zMin = 0.125f;
                }
            } else if (this.getFacing() == Direction.EAST) {
                xMax = 0.8125f;
                if (is11) {
                    zMax = 0.875f;
                }
            }
        }
        if (new BlockPos(2, 1, 0).equals((Object)this.posInMultiblock)) {
            yMax = 0.3125f;
            if (this.getFacing() == Direction.NORTH) {
                zMin = 0.25f;
                xMax = 0.875f;
            } else if (this.getFacing() == Direction.SOUTH) {
                zMax = 0.75f;
                xMin = 0.125f;
            } else if (this.getFacing() == Direction.WEST) {
                xMin = 0.25f;
                zMin = 0.125f;
            } else if (this.getFacing() == Direction.EAST) {
                xMax = 0.75f;
                zMax = 0.875f;
            }
        }
        return VoxelShapes.func_197873_a((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 2));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 2));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output, output, false)).func_190926_b()) {
            DirectionalBlockPos outputPos = this.getOutputPos();
            Utils.dropStackAtPos(this.field_145850_b, outputPos.getPosition(), output, outputPos.getSide().func_176734_d());
        }
    }

    private DirectionalBlockPos getOutputPos() {
        Direction outDir = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
        return new DirectionalBlockPos(this.field_174879_c.func_177967_a(outDir, 2), outDir.func_176734_d());
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 3;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 3;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return 0.4375f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates() {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        AutoWorkbenchTileEntity master;
        if (new BlockPos(0, 1, 2).equals((Object)this.posInMultiblock) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (master = (AutoWorkbenchTileEntity)this.master()) != null) {
            return master.insertionHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected BlueprintCraftingRecipe getRecipeForId(ResourceLocation id) {
        return BlueprintCraftingRecipe.recipeList.get(id);
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)((Object)this.master());
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return true;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return true;
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(1, 1, 2).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getFacing().func_176746_e()};
        }
        return new Direction[0];
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, BlockState state, ItemStack stack, int h, int l, int w) {
        if (state.func_177230_c() == ConveyorHandler.getBlock(BasicConveyor.NAME)) {
            state = l == 2 && w == 0 || l == 1 ? (BlockState)state.func_206870_a((Property)IEProperties.FACING_ALL, (Comparable)this.getFacing().func_176746_e()) : (BlockState)state.func_206870_a((Property)IEProperties.FACING_ALL, (Comparable)this.getFacing().func_176734_d());
        }
        super.replaceStructureBlock(pos, state, stack, h, l, w);
    }
}

