/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.block.MaterialJS;
import dev.latvian.kubejs.block.MaterialListJS;
import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.item.InventoryJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.player.ServerPlayerJS;
import dev.latvian.kubejs.util.Tags;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.ExplosionJS;
import dev.latvian.kubejs.world.FireworksJS;
import dev.latvian.kubejs.world.WorldJS;
import dev.latvian.kubejs.world.forge.BlockContainerJSImpl;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.architectury.hooks.PlayerHooks;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class BlockContainerJS
implements SpecialEquality {
    private static final ResourceLocation AIR_ID = new ResourceLocation("minecraft:air");
    public final World minecraftLevel;
    private final BlockPos pos;
    private BlockState cachedState;
    private TileEntity cachedEntity;

    public BlockContainerJS(World w, BlockPos p) {
        this.minecraftLevel = w;
        this.pos = p;
    }

    public void clearCache() {
        this.cachedState = null;
        this.cachedEntity = null;
    }

    public WorldJS getLevel() {
        return UtilsJS.getWorld(this.minecraftLevel);
    }

    public WorldJS getWorld() {
        return UtilsJS.getWorld(this.minecraftLevel);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getDimension() {
        return this.minecraftLevel.func_234923_W_().func_240901_a_().toString();
    }

    public int getX() {
        return this.getPos().func_177958_n();
    }

    public int getY() {
        return this.getPos().func_177956_o();
    }

    public int getZ() {
        return this.getPos().func_177952_p();
    }

    public BlockContainerJS offset(Direction f, int d) {
        return new BlockContainerJS(this.minecraftLevel, this.getPos().func_177967_a(f, d));
    }

    public BlockContainerJS offset(Direction f) {
        return this.offset(f, 1);
    }

    public BlockContainerJS offset(int x, int y, int z) {
        return new BlockContainerJS(this.minecraftLevel, this.getPos().func_177982_a(x, y, z));
    }

    public BlockContainerJS getDown() {
        return this.offset(Direction.DOWN);
    }

    public BlockContainerJS getUp() {
        return this.offset(Direction.UP);
    }

    public BlockContainerJS getNorth() {
        return this.offset(Direction.NORTH);
    }

    public BlockContainerJS getSouth() {
        return this.offset(Direction.SOUTH);
    }

    public BlockContainerJS getWest() {
        return this.offset(Direction.WEST);
    }

    public BlockContainerJS getEast() {
        return this.offset(Direction.EAST);
    }

    public BlockState getBlockState() {
        if (this.cachedState == null) {
            this.cachedState = this.minecraftLevel.func_180495_p(this.getPos());
        }
        return this.cachedState;
    }

    public void setBlockState(BlockState state, int flags) {
        this.minecraftLevel.func_180501_a(this.getPos(), state, flags);
        this.clearCache();
    }

    public String getId() {
        return Registries.getId((Object)this.getBlockState().func_177230_c(), (RegistryKey)Registry.field_239711_l_).toString();
    }

    public Collection<ResourceLocation> getTags() {
        return Tags.byBlockState(this.getBlockState());
    }

    public boolean hasTag(ResourceLocation tag) {
        return Tags.blocks().func_241834_b(tag).func_230235_a_((Object)this.getBlockState().func_177230_c());
    }

    public void set(ResourceLocation id, Map<?, ?> properties, int flags) {
        Block block = (Block)KubeJSRegistries.blocks().get(id);
        BlockState state = block.func_176223_P();
        if (!properties.isEmpty() && state.func_177230_c() != Blocks.field_150350_a) {
            HashMap<String, Property> pmap = new HashMap<String, Property>();
            for (Property property : state.func_235904_r_()) {
                pmap.put(property.func_177701_a(), property);
            }
            for (Map.Entry entry : properties.entrySet()) {
                Property property = (Property)pmap.get(String.valueOf(entry.getKey()));
                if (property == null) continue;
                state = (BlockState)state.func_206870_a(property, (Comparable)UtilsJS.cast(property.func_185929_b(String.valueOf(entry.getValue())).get()));
            }
        }
        this.setBlockState(state, flags);
    }

    public void set(ResourceLocation id, Map<?, ?> properties) {
        this.set(id, properties, 3);
    }

    public void set(ResourceLocation id) {
        this.set(id, Collections.emptyMap());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        BlockState state = this.getBlockState();
        for (Property property : state.func_235904_r_()) {
            map.put(property.func_177701_a(), property.func_177702_a(state.func_177229_b(property)));
        }
        return map;
    }

    @Nullable
    public TileEntity getEntity() {
        if (this.cachedEntity == null || this.cachedEntity.func_145837_r()) {
            this.cachedEntity = this.minecraftLevel.func_175625_s(this.pos);
        }
        return this.cachedEntity;
    }

    public String getEntityId() {
        TileEntity entity = this.getEntity();
        return entity == null ? "minecraft:air" : Registries.getId((Object)entity.func_200662_C(), (RegistryKey)Registry.field_239667_E_).toString();
    }

    @Nullable
    public CompoundNBT getEntityData() {
        TileEntity entity = this.getEntity();
        if (entity != null) {
            return entity.func_189515_b(new CompoundNBT());
        }
        return null;
    }

    public void setEntityData(@Nullable CompoundNBT tag) {
        TileEntity entity;
        if (tag != null && (entity = this.getEntity()) != null) {
            entity.func_230337_a_(entity.func_195044_w(), tag);
        }
    }

    public void mergeEntityData(@Nullable CompoundNBT tag) {
        CompoundNBT t = this.getEntityData();
        if (t == null) {
            this.setEntityData(tag);
        } else if (tag != null && !tag.isEmpty()) {
            for (String s : tag.func_150296_c()) {
                t.func_218657_a(s, tag.func_74781_a(s));
            }
        }
        this.setEntityData(t);
    }

    public int getLight() {
        return this.minecraftLevel.func_201696_r(this.pos);
    }

    public boolean getCanSeeSky() {
        return this.minecraftLevel.func_175710_j(this.pos);
    }

    public String toString() {
        String id = this.getId();
        Map<String, String> properties = this.getProperties();
        if (properties.isEmpty()) {
            return id;
        }
        StringBuilder builder = new StringBuilder(id);
        builder.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        builder.append(']');
        return builder.toString();
    }

    public ExplosionJS createExplosion() {
        return new ExplosionJS((IWorld)this.minecraftLevel, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
    }

    @Nullable
    public EntityJS createEntity(ResourceLocation id) {
        EntityJS entity = this.getWorld().createEntity(id);
        if (entity != null) {
            entity.setPosition(this);
        }
        return entity;
    }

    public void spawnLightning(boolean effectOnly, @Nullable EntityJS player) {
        if (this.minecraftLevel instanceof ServerWorld) {
            LightningBoltEntity e = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.minecraftLevel);
            e.func_225653_b_((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
            e.func_204809_d(player instanceof ServerPlayerJS ? (ServerPlayerEntity)((ServerPlayerJS)player).minecraftPlayer : null);
            this.minecraftLevel.func_217376_c((Entity)e);
        }
    }

    public void spawnLightning(boolean effectOnly) {
        this.spawnLightning(effectOnly, null);
    }

    public void spawnFireworks(FireworksJS fireworks) {
        this.minecraftLevel.func_217376_c((Entity)fireworks.createFireworkRocket(this.minecraftLevel, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5));
    }

    @Nullable
    public InventoryJS getInventory(Direction facing) {
        TileEntity tileEntity = this.getEntity();
        if (tileEntity != null) {
            return BlockContainerJS.getInventoryFromBlockEntity(tileEntity, facing);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static InventoryJS getInventoryFromBlockEntity(TileEntity tileEntity, Direction facing) {
        void var1_1;
        return BlockContainerJSImpl.getInventoryFromBlockEntity(tileEntity, (Direction)var1_1);
    }

    public MaterialJS getMaterial() {
        return MaterialListJS.INSTANCE.get(this.getBlockState().func_185904_a());
    }

    public ItemStackJS getItem() {
        BlockState state = this.getBlockState();
        return ItemStackJS.of(state.func_177230_c().func_185473_a((IBlockReader)this.minecraftLevel, this.pos, state));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharSequence || obj instanceof ResourceLocation) {
            return this.getId().equals(obj.toString());
        }
        return super.equals(obj);
    }

    private static boolean isReal(PlayerEntity p) {
        return !PlayerHooks.isFake((PlayerEntity)p);
    }

    public EntityArrayList getPlayersInRadius(double radius) {
        EntityArrayList list = new EntityArrayList(this.getWorld(), 1);
        for (PlayerEntity player : this.minecraftLevel.func_175647_a(PlayerEntity.class, new AxisAlignedBB((double)this.pos.func_177958_n() - radius, (double)this.pos.func_177956_o() - radius, (double)this.pos.func_177952_p() - radius, (double)this.pos.func_177958_n() + 1.0 + radius, (double)this.pos.func_177956_o() + 1.0 + radius, (double)this.pos.func_177952_p() + 1.0 + radius), BlockContainerJS::isReal)) {
            PlayerJS p = this.getWorld().getPlayer((Entity)player);
            if (p == null) continue;
            list.add(p);
        }
        return list;
    }

    public EntityArrayList getPlayersInRadius() {
        return this.getPlayersInRadius(8.0);
    }

    public String getBiomeId() {
        Optional key = this.minecraftLevel.func_242406_i(this.pos);
        return key.isPresent() ? ((RegistryKey)key.get()).func_240901_a_().toString() : "";
    }

    public boolean specialEquals(Object o, boolean shallow) {
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            return this.getId().equals(o.toString());
        }
        return this.equals(o);
    }
}

