/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSPlugin;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.ClassFilter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class KubeJSPlugins {
    private static final List<KubeJSPlugin> LIST = new ArrayList<KubeJSPlugin>();
    private static final List<String> GLOBAL_CLASS_FILTER = new ArrayList<String>();

    public static void load(String id, Path path) throws Exception {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Path pc;
            Path pp = path.resolve("kubejs.plugins.txt");
            if (Files.exists(pp, new LinkOption[0])) {
                KubeJSPlugins.loadFromFile(id, Files.readAllLines(pp));
            }
            if (Files.exists(pc = path.resolve("kubejs.classfilter.txt"), new LinkOption[0])) {
                GLOBAL_CLASS_FILTER.addAll(Files.readAllLines(pc));
            }
        } else if (Files.isRegularFile(path, new LinkOption[0]) && (path.getFileName().toString().endsWith(".jar") || path.getFileName().toString().endsWith(".zip"))) {
            ZipEntry zec;
            String s;
            ZipFile file = new ZipFile(path.toFile());
            ZipEntry zep = file.getEntry("kubejs.plugins.txt");
            if (zep != null) {
                try (InputStream stream = file.getInputStream(zep);
                     BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(stream), StandardCharsets.UTF_8));){
                    ArrayList<String> list = new ArrayList<String>();
                    while ((s = reader.readLine()) != null) {
                        list.add(s);
                    }
                    KubeJSPlugins.loadFromFile(id, list);
                }
            }
            if ((zec = file.getEntry("kubejs.classfilter.txt")) != null) {
                try (InputStream stream = file.getInputStream(zec);
                     BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(stream), StandardCharsets.UTF_8));){
                    while ((s = reader.readLine()) != null) {
                        GLOBAL_CLASS_FILTER.add(s);
                    }
                }
            }
        }
    }

    private static void loadFromFile(String id, List<String> list) {
        KubeJS.LOGGER.info("Found " + id + " plugin");
        for (String s : list) {
            if (s.trim().isEmpty()) continue;
            try {
                Class<?> c = Class.forName(s);
                if (!KubeJSPlugin.class.isAssignableFrom(c)) continue;
                LIST.add((KubeJSPlugin)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static ClassFilter createClassFilter(ScriptType type) {
        ClassFilter filter = new ClassFilter();
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addClasses(type, filter));
        for (String s : GLOBAL_CLASS_FILTER) {
            if (s.length() < 2) continue;
            if (s.startsWith("+")) {
                filter.allow(s.substring(1));
                continue;
            }
            if (!s.startsWith("-")) continue;
            filter.deny(s.substring(1));
        }
        return filter;
    }

    public static void forEachPlugin(Consumer<KubeJSPlugin> callback) {
        LIST.forEach(callback);
    }
}

