/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.KubeJSPaths;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.JsonUtilsJS;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import me.shedaniel.architectury.registry.Registry;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class ServerSettings {
    public static ServerSettings instance;
    public boolean dataPackOutput = false;
    public boolean logAddedRecipes = false;
    public boolean logRemovedRecipes = false;
    public boolean logOverrides = false;
    public boolean logSkippedRecipes = false;
    public boolean logErroringRecipes = true;
    public boolean logInvalidRecipeHandlers = true;
    public boolean useOriginalRecipeForFilters = true;
    public static transient CommandSource source;
    public static transient JsonObject dataExport;

    public static void exportData() {
        if (dataExport != null) {
            Util.func_240992_g_().execute(ServerSettings::exportDataBlocking);
        }
    }

    private static <T> void addRegistry(JsonObject o, String name, Registry<T> r) {
        JsonArray a = new JsonArray();
        for (ResourceLocation id : r.getIds()) {
            a.add(id.toString());
        }
        o.add(name, (JsonElement)a);
    }

    private static void exportDataBlocking() {
        JsonObject registries = new JsonObject();
        ServerSettings.addRegistry(registries, "items", KubeJSRegistries.items());
        ServerSettings.addRegistry(registries, "blocks", KubeJSRegistries.blocks());
        ServerSettings.addRegistry(registries, "fluids", KubeJSRegistries.fluids());
        ServerSettings.addRegistry(registries, "entity_types", KubeJSRegistries.entityTypes());
        dataExport.add("registries", (JsonElement)registries);
        JsonArray errors = new JsonArray();
        for (String string : ScriptType.SERVER.errors) {
            errors.add(string);
        }
        dataExport.add("errors", (JsonElement)errors);
        JsonArray warnings = new JsonArray();
        for (String s : ScriptType.SERVER.warnings) {
            warnings.add(s);
        }
        dataExport.add("warnings", (JsonElement)warnings);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(KubeJSPaths.EXPORTED.resolve("kubejs-server-export.json"), new OpenOption[0]);){
            JsonUtilsJS.GSON.toJson((JsonElement)dataExport, (Appendable)bufferedWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Done! Export in kubejs/exported/kubejs-server-export.json"), false);
        source.func_197030_a((ITextComponent)new StringTextComponent("You can now upload it on ").func_230529_a_((ITextComponent)new StringTextComponent("https://export.kubejs.com/").func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.UNDERLINE}).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://export.kubejs.com/")))), false);
        source = null;
        dataExport = null;
    }
}

