/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import com.mojang.authlib.GameProfile;
import dev.latvian.kubejs.core.PlayerKJS;
import dev.latvian.kubejs.entity.LivingEntityJS;
import dev.latvian.kubejs.item.InventoryJS;
import dev.latvian.kubejs.item.ItemHandlerUtils;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.player.PlayerDataJS;
import dev.latvian.kubejs.player.PlayerStatsJS;
import dev.latvian.kubejs.stages.Stages;
import dev.latvian.kubejs.util.AttachedData;
import dev.latvian.kubejs.util.WithAttachedData;
import dev.latvian.kubejs.world.WorldJS;
import me.shedaniel.architectury.hooks.PlayerHooks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerJS<E extends PlayerEntity>
extends LivingEntityJS
implements WithAttachedData {
    public final E minecraftPlayer;
    private final PlayerDataJS playerData;
    private InventoryJS inventory;

    public PlayerJS(PlayerDataJS d, WorldJS w, E p) {
        super(w, (LivingEntity)p);
        this.playerData = d;
        this.minecraftPlayer = p;
    }

    @Override
    public AttachedData getData() {
        return this.playerData.getData();
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    public boolean isFake() {
        return PlayerHooks.isFake(this.minecraftPlayer);
    }

    @Override
    public String toString() {
        return this.minecraftPlayer.func_146103_bH().getName();
    }

    @Override
    public GameProfile getProfile() {
        return this.minecraftPlayer.func_146103_bH();
    }

    public InventoryJS getInventory() {
        if (this.inventory == null) {
            this.inventory = new InventoryJS((IInventory)((PlayerEntity)this.minecraftPlayer).field_71071_by){

                @Override
                public void markDirty() {
                    PlayerJS.this.sendInventoryUpdate();
                }
            };
        }
        return this.inventory;
    }

    public void sendInventoryUpdate() {
        ((PlayerEntity)this.minecraftPlayer).field_71071_by.func_70296_d();
        ((PlayerEntity)this.minecraftPlayer).field_71069_bz.func_75142_b();
    }

    public void give(ItemStackJS item) {
        ItemHandlerUtils.giveItemToPlayer(this.minecraftPlayer, item.getItemStack(), -1);
    }

    public void giveInHand(ItemStackJS item) {
        ItemHandlerUtils.giveItemToPlayer(this.minecraftPlayer, item.getItemStack(), this.getSelectedSlot());
    }

    public int getSelectedSlot() {
        return ((PlayerEntity)this.minecraftPlayer).field_71071_by.field_70461_c;
    }

    public void setSelectedSlot(int index) {
        ((PlayerEntity)this.minecraftPlayer).field_71071_by.field_70461_c = MathHelper.func_76125_a((int)index, (int)0, (int)8);
    }

    public ItemStackJS getMouseItem() {
        return ItemStackJS.of(((PlayerEntity)this.minecraftPlayer).field_71071_by.func_70445_o());
    }

    public void setMouseItem(ItemStackJS item) {
        ((PlayerEntity)this.minecraftPlayer).field_71071_by.func_70437_b(item.getItemStack());
    }

    @Override
    public void setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        super.setPositionAndRotation(x, y, z, yaw, pitch);
        if (this.minecraftPlayer instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)this.minecraftPlayer).field_71135_a.func_147364_a(x, y, z, yaw, pitch);
        }
    }

    @Override
    public void setStatusMessage(ITextComponent message) {
        this.minecraftPlayer.func_146105_b(message, true);
    }

    public boolean isCreativeMode() {
        return this.minecraftPlayer.func_184812_l_();
    }

    public boolean isSpectator() {
        return this.minecraftPlayer.func_175149_v();
    }

    public abstract PlayerStatsJS getStats();

    @Override
    public void spawn() {
    }

    public void sendData(String channel, @Nullable CompoundNBT data) {
    }

    public void addFood(int f, float m) {
        this.minecraftPlayer.func_71024_bL().func_75122_a(f, m);
    }

    public int getFoodLevel() {
        return this.minecraftPlayer.func_71024_bL().func_75116_a();
    }

    public void setFoodLevel(int foodLevel) {
        this.minecraftPlayer.func_71024_bL().func_75114_a(foodLevel);
    }

    public void addExhaustion(float exhaustion) {
        this.minecraftPlayer.func_71020_j(exhaustion);
    }

    public void addXP(int xp) {
        this.minecraftPlayer.func_195068_e(xp);
    }

    public void addXPLevels(int l) {
        this.minecraftPlayer.func_82242_a(l);
    }

    public void setXp(int xp) {
        ((PlayerEntity)this.minecraftPlayer).field_71067_cb = 0;
        ((PlayerEntity)this.minecraftPlayer).field_71106_cc = 0.0f;
        ((PlayerEntity)this.minecraftPlayer).field_71068_ca = 0;
        this.minecraftPlayer.func_195068_e(xp);
    }

    public int getXp() {
        return ((PlayerEntity)this.minecraftPlayer).field_71067_cb;
    }

    public void setXpLevel(int l) {
        ((PlayerEntity)this.minecraftPlayer).field_71067_cb = 0;
        ((PlayerEntity)this.minecraftPlayer).field_71106_cc = 0.0f;
        ((PlayerEntity)this.minecraftPlayer).field_71068_ca = 0;
        this.minecraftPlayer.func_82242_a(l);
    }

    public int getXpLevel() {
        return ((PlayerEntity)this.minecraftPlayer).field_71068_ca;
    }

    public abstract void paint(CompoundNBT var1);

    public void boostElytraFlight() {
        if (this.minecraftPlayer.func_184613_cA()) {
            Vector3d v = this.minecraftPlayer.func_70040_Z();
            double d0 = 1.5;
            double d1 = 0.1;
            Vector3d m = this.minecraftPlayer.func_213322_ci();
            this.minecraftPlayer.func_213317_d(m.func_72441_c(v.field_72450_a * 0.1 + (v.field_72450_a * 1.5 - m.field_72450_a) * 0.5, v.field_72448_b * 0.1 + (v.field_72448_b * 1.5 - m.field_72448_b) * 0.5, v.field_72449_c * 0.1 + (v.field_72449_c * 1.5 - m.field_72449_c) * 0.5));
        }
    }

    public void closeInventory() {
        PlayerHooks.closeContainer(this.minecraftPlayer);
    }

    public Container getOpenInventory() {
        return ((PlayerEntity)this.minecraftPlayer).field_71070_bA;
    }

    public abstract boolean isMiningBlock();

    public void addItemCooldown(Item item, int ticks) {
        this.minecraftPlayer.func_184811_cZ().func_185145_a(item, ticks);
    }

    public int getAirSupply() {
        return this.minecraftPlayer.func_70086_ai();
    }

    public void setAirSupply(int air) {
        this.minecraftPlayer.func_70050_g(air);
    }

    public int getMaxAirSupply() {
        return this.minecraftPlayer.func_205010_bg();
    }

    public Stages getStages() {
        return ((PlayerKJS)this.minecraftPlayer).getStagesKJS();
    }
}

