/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.text.TextString;
import dev.latvian.kubejs.util.MessageSender;
import dev.latvian.kubejs.world.WorldJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public class EntityArrayList
extends ArrayList<EntityJS>
implements MessageSender {
    private final WorldJS world;

    public EntityArrayList(WorldJS w, int size) {
        super(size);
        this.world = w;
    }

    public EntityArrayList(WorldJS w, Iterable<? extends Entity> c) {
        this(w, c instanceof Collection ? ((Collection)c).size() : 10);
        for (Entity entity : c) {
            this.add(this.world.getEntity(entity));
        }
    }

    public WorldJS getWorld() {
        return this.world;
    }

    @Override
    public Text getName() {
        return new TextString("EntityList");
    }

    @Override
    public Text getDisplayName() {
        return new TextString(this.toString()).lightPurple();
    }

    @Override
    public void tell(ITextComponent message) {
        for (EntityJS entity : this) {
            entity.minecraftEntity.func_145747_a(message, Util.field_240973_b_);
        }
    }

    @Override
    public void setStatusMessage(ITextComponent message) {
        for (EntityJS entity : this) {
            if (!(entity.minecraftEntity instanceof ServerPlayerEntity)) continue;
            ((ServerPlayerEntity)entity.minecraftEntity).func_146105_b(message, true);
        }
    }

    @Override
    public int runCommand(String command) {
        int m = 0;
        for (EntityJS entity : this) {
            m = Math.max(m, entity.runCommand(command));
        }
        return m;
    }

    @Override
    public int runCommandSilent(String command) {
        int m = 0;
        for (EntityJS entity : this) {
            m = Math.max(m, entity.runCommandSilent(command));
        }
        return m;
    }

    public void kill() {
        for (EntityJS entity : this) {
            entity.kill();
        }
    }

    public void playSound(SoundEvent id, float volume, float pitch) {
        for (EntityJS entity : this) {
            entity.minecraftEntity.field_70170_p.func_184148_a(null, entity.getX(), entity.getY(), entity.getZ(), id, entity.minecraftEntity.func_184176_by(), volume, pitch);
        }
    }

    public void playSound(SoundEvent id) {
        this.playSound(id, 1.0f, 1.0f);
    }

    public EntityArrayList filter(Predicate<EntityJS> filter) {
        if (this.isEmpty()) {
            return this;
        }
        EntityArrayList list = new EntityArrayList(this.world, this.size());
        for (EntityJS entity : this) {
            if (!filter.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public void sendData(String channel, @Nullable CompoundNBT data) {
        for (EntityJS entity : this) {
            if (!(entity instanceof PlayerJS)) continue;
            ((PlayerJS)entity).sendData(channel, data);
        }
    }

    @Override
    public EntityJS getFirst() {
        return (EntityJS)this.get(0);
    }
}

