/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.loot.ConditionContainer;
import dev.latvian.kubejs.loot.FunctionContainer;
import dev.latvian.kubejs.loot.LootTableEntry;
import dev.latvian.kubejs.util.UtilsJS;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class LootBuilderPool
implements FunctionContainer,
ConditionContainer {
    public IRandomRange rolls = new ConstantRange(1);
    public IRandomRange bonusRolls = null;
    public final JsonArray conditions = new JsonArray();
    public final JsonArray functions = new JsonArray();
    public final JsonArray entries = new JsonArray();

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("rolls", UtilsJS.randomIntGeneratorJson(this.rolls));
        if (this.bonusRolls != null) {
            json.add("bonus_rolls", UtilsJS.randomIntGeneratorJson(this.bonusRolls));
        }
        if (this.conditions.size() > 0) {
            json.add("conditions", (JsonElement)this.conditions);
        }
        if (this.functions.size() > 0) {
            json.add("functions", (JsonElement)this.functions);
        }
        if (this.entries.size() > 0) {
            json.add("entries", (JsonElement)this.entries);
        }
        return json;
    }

    public void setUniformRolls(float min, float max) {
        this.rolls = new RandomValueRange(min, max);
    }

    public void setBinomialRolls(int n, float p) {
        this.rolls = new BinomialRange(n, p);
    }

    @Override
    public LootBuilderPool addFunction(JsonObject o) {
        this.functions.add((JsonElement)o);
        return this;
    }

    @Override
    public LootBuilderPool addCondition(JsonObject o) {
        this.conditions.add((JsonElement)o);
        return this;
    }

    public LootTableEntry addEntry(JsonObject json) {
        this.entries.add((JsonElement)json);
        return new LootTableEntry(json);
    }

    public LootTableEntry addEmpty(int weight) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:empty");
        return this.addEntry(json).weight(weight);
    }

    public LootTableEntry addLootTable(ResourceLocation table) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:loot_table");
        json.addProperty("name", table.toString());
        return this.addEntry(json);
    }

    public LootTableEntry addItem(ItemStack item, int weight, @Nullable IRandomRange count) {
        ResourceLocation id = KubeJSRegistries.items().getId((Object)item.func_77973_b());
        if (id == null || item.func_190926_b()) {
            return new LootTableEntry(new JsonObject());
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:item");
        json.addProperty("name", id.toString());
        LootTableEntry entry = this.addEntry(json);
        if (weight >= 0) {
            entry.weight(weight);
        }
        if (count == null && item.func_190916_E() > 1) {
            count = ConstantRange.func_215835_a((int)item.func_190916_E());
        }
        if (count != null) {
            entry.count(count);
        }
        if (item.func_77978_p() != null) {
            entry.nbt(item.func_77978_p());
        }
        return entry;
    }

    public LootTableEntry addItem(ItemStack item, int weight) {
        return this.addItem(item, weight, null);
    }

    public LootTableEntry addItem(ItemStack item) {
        return this.addItem(item, -1, null);
    }

    public LootTableEntry addTag(String tag, boolean expand) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:tag");
        json.addProperty("name", tag);
        json.addProperty("expand", Boolean.valueOf(expand));
        return this.addEntry(json);
    }
}

