/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.bindings.RarityWrapper;
import dev.latvian.kubejs.item.FoodBuilder;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.custom.ArmorItemType;
import dev.latvian.kubejs.item.custom.BasicItemType;
import dev.latvian.kubejs.item.custom.ItemType;
import dev.latvian.kubejs.item.forge.ItemBuilderImpl;
import dev.latvian.kubejs.util.BuilderBase;
import dev.latvian.kubejs.util.ConsoleJS;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.architectury.registry.ToolType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder
extends BuilderBase {
    public static final Map<String, IItemTier> TOOL_TIERS = new HashMap<String, IItemTier>();
    public static final Map<String, IArmorMaterial> ARMOR_TIERS = new HashMap<String, IArmorMaterial>();
    public transient ItemType type = BasicItemType.INSTANCE;
    public transient int maxStackSize = 64;
    public transient int maxDamage = 0;
    public transient int burnTime = 0;
    public transient String containerItem = "minecraft:air";
    public transient Function<ItemStackJS, Collection<ItemStackJS>> subtypes = null;
    public transient Map<ToolType, Integer> tools = new HashMap<ToolType, Integer>();
    public transient float miningSpeed = 1.0f;
    public transient Float attackDamage;
    public transient Float attackSpeed;
    public transient RarityWrapper rarity = RarityWrapper.COMMON;
    public transient boolean glow = false;
    public final transient List<ITextComponent> tooltip = new ArrayList<ITextComponent>();
    public transient ItemGroup group = KubeJS.tab;
    public transient Int2IntOpenHashMap color = new Int2IntOpenHashMap();
    public String texture;
    public String parentModel;
    public transient FoodBuilder foodBuilder;
    public transient Set<String> defaultTags;
    public transient IItemTier toolTier;
    public transient float attackDamageBaseline;
    public transient float attackSpeedBaseline;
    public transient IArmorMaterial armorTier;
    public transient Item item;
    public JsonObject modelJson;

    public ItemBuilder(String i) {
        super(i);
        this.color.defaultReturnValue(-1);
        this.texture = "";
        this.parentModel = "";
        this.foodBuilder = null;
        this.defaultTags = new HashSet<String>();
        this.toolTier = ItemTier.IRON;
        this.armorTier = ArmorMaterial.IRON;
        this.displayName = "";
        this.modelJson = null;
    }

    @Override
    public String getBuilderType() {
        return "item";
    }

    public ItemBuilder type(ItemType t) {
        this.type = t;
        this.type.applyDefaults(this);
        return this;
    }

    public ItemBuilder tier(String t) {
        if (this.type == BasicItemType.INSTANCE) {
            return this;
        }
        if (this.type instanceof ArmorItemType) {
            this.armorTier = ARMOR_TIERS.getOrDefault(t, (IArmorMaterial)ArmorMaterial.IRON);
            return this;
        }
        this.toolTier = TOOL_TIERS.getOrDefault(t, (IItemTier)ItemTier.IRON);
        return this;
    }

    public ItemBuilder maxStackSize(int v) {
        this.maxStackSize = v;
        return this;
    }

    public ItemBuilder unstackable() {
        return this.maxStackSize(1);
    }

    public ItemBuilder maxDamage(int v) {
        this.maxDamage = v;
        return this;
    }

    public ItemBuilder burnTime(int v) {
        this.burnTime = v;
        return this;
    }

    public ItemBuilder containerItem(String id) {
        this.containerItem = id;
        return this;
    }

    public ItemBuilder subtypes(Function<ItemStackJS, Collection<ItemStackJS>> fn) {
        this.subtypes = fn;
        return this;
    }

    public ItemBuilder tool(ToolType type, int level) {
        this.tools.put(type, level);
        return this;
    }

    public ItemBuilder miningSpeed(float f) {
        this.miningSpeed = f;
        ConsoleJS.STARTUP.warn("You should be using a 'pickaxe' or other tool type item if you want to modify mining speed!");
        return this;
    }

    public ItemBuilder attackDamage(float f) {
        this.attackDamage = Float.valueOf(f);
        ConsoleJS.STARTUP.warn("You should be using a 'sword' type item if you want to modify attack damage!");
        return this;
    }

    public ItemBuilder attackSpeed(float f) {
        this.attackSpeed = Float.valueOf(f);
        ConsoleJS.STARTUP.warn("You should be using a 'sword' type item if you want to modify attack speed!");
        return this;
    }

    public ItemBuilder rarity(RarityWrapper v) {
        this.rarity = v;
        return this;
    }

    public ItemBuilder glow(boolean v) {
        this.glow = v;
        return this;
    }

    public ItemBuilder tooltip(ITextComponent text) {
        this.tooltip.add(text);
        return this;
    }

    public ItemBuilder group(String g) {
        for (ItemGroup ig : ItemGroup.field_78032_a) {
            if (!ig.func_200300_c().equals(g)) continue;
            this.group = ig;
            return this;
        }
        return this;
    }

    public ItemBuilder color(int index, int c) {
        this.color.put(index, 0xFF000000 | c);
        return this;
    }

    public ItemBuilder texture(String tex) {
        this.texture = tex;
        return this;
    }

    public ItemBuilder parentModel(String m) {
        this.parentModel = m;
        return this;
    }

    public ItemBuilder food(Consumer<FoodBuilder> b) {
        this.foodBuilder = new FoodBuilder();
        b.accept(this.foodBuilder);
        return this;
    }

    public Map<ToolType, Integer> getToolsMap() {
        return this.tools;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    @Nullable
    public Float getAttackDamage() {
        return this.attackDamage;
    }

    @Nullable
    public Float getAttackSpeed() {
        return this.attackSpeed;
    }

    public ItemBuilder tag(String tag) {
        this.defaultTags.add(tag);
        return this;
    }

    public Item.Properties createItemProperties() {
        Item.Properties properties = new Item.Properties();
        properties.func_200916_a(this.group);
        if (this.maxDamage > 0) {
            properties.func_200918_c(this.maxDamage);
        } else {
            properties.func_200917_a(this.maxStackSize);
        }
        properties.func_208103_a(this.rarity.rarity);
        for (Map.Entry<ToolType, Integer> entry : this.tools.entrySet()) {
            ItemBuilder.appendToolType(properties, entry.getKey(), entry.getValue());
        }
        Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(this.containerItem));
        if (item != Items.field_190931_a) {
            properties.func_200919_a(item);
        }
        if (this.foodBuilder != null) {
            properties.func_221540_a(this.foodBuilder.build());
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void appendToolType(Item.Properties properties, ToolType type, Integer level) {
        void var2_2;
        void var1_1;
        ItemBuilderImpl.appendToolType(properties, (ToolType)var1_1, (Integer)var2_2);
    }

    static {
        for (ItemTier itemTier : ItemTier.values()) {
            TOOL_TIERS.put(itemTier.toString().toLowerCase(), (IItemTier)itemTier);
        }
        for (ItemTier itemTier : ArmorMaterial.values()) {
            ARMOR_TIERS.put(itemTier.toString().toLowerCase(), (IArmorMaterial)itemTier);
        }
    }
}

