/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.forge;

import dev.latvian.kubejs.CommonProperties;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.block.forge.MissingMappingEventJS;
import dev.latvian.kubejs.entity.ItemEntityJS;
import dev.latvian.kubejs.entity.forge.CheckLivingEntitySpawnEventJS;
import dev.latvian.kubejs.entity.forge.LivingEntityDropsEventJS;
import dev.latvian.kubejs.integration.IntegrationManager;
import dev.latvian.kubejs.item.forge.ItemDestroyedEventJS;
import dev.latvian.kubejs.item.ingredient.forge.CustomPredicateIngredient;
import dev.latvian.kubejs.item.ingredient.forge.IgnoreNBTIngredient;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import me.shedaniel.architectury.platform.forge.EventBuses;
import net.minecraft.block.Block;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="kubejs")
public class KubeJSForge {
    public KubeJSForge() throws Throwable {
        EventBuses.registerModEventBus((String)"kubejs", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(KubeJSForge::loadComplete);
        KubeJS.instance = new KubeJS();
        KubeJS.instance.setup();
        IntegrationManager.init();
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        MinecraftForge.EVENT_BUS.addGenericListener(Block.class, KubeJSForge::missingBlockMappings);
        MinecraftForge.EVENT_BUS.addGenericListener(Item.class, KubeJSForge::missingItemMappings);
        MinecraftForge.EVENT_BUS.addListener(KubeJSForge::itemDestroyed);
        MinecraftForge.EVENT_BUS.addListener(KubeJSForge::livingDrops);
        MinecraftForge.EVENT_BUS.addListener(KubeJSForge::checkLivingSpawn);
        if (!CommonProperties.get().serverOnly) {
            try {
                ForgeMod.class.getDeclaredMethod("enableMilkFluid", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        CraftingHelper.register((ResourceLocation)new ResourceLocation("kubejs:custom_predicate"), CustomPredicateIngredient.SERIALIZER);
        CraftingHelper.register((ResourceLocation)new ResourceLocation("kubejs:ignore_nbt"), IgnoreNBTIngredient.SERIALIZER);
    }

    private static void loadComplete(FMLLoadCompleteEvent event) {
        KubeJS.instance.loadComplete();
    }

    private static void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        new MissingMappingEventJS<Block>(event, arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).post(ScriptType.STARTUP, "block.missing_mappings");
    }

    private static void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        new MissingMappingEventJS<Item>(event, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).post(ScriptType.STARTUP, "item.missing_mappings");
    }

    private static void itemDestroyed(PlayerDestroyItemEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            new ItemDestroyedEventJS(event).post("item.destroyed");
        }
    }

    private static void livingDrops(LivingDropsEvent event) {
        if (event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        LivingEntityDropsEventJS e = new LivingEntityDropsEventJS(event);
        if (e.post("entity.drops")) {
            event.setCanceled(true);
        } else if (e.eventDrops != null) {
            event.getDrops().clear();
            for (ItemEntityJS ie : e.eventDrops) {
                event.getDrops().add((ItemEntity)ie.minecraftEntity);
            }
        }
    }

    private static void checkLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && !event.getWorld().func_201670_d() && new CheckLivingEntitySpawnEventJS(event).post(ScriptType.SERVER, "entity.check_spawn")) {
            event.setResult(Event.Result.DENY);
        }
    }
}

