/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pressurizer;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pressurizer.PressurizerContainer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class PressurizerTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity,
IPipeConnectable {
    private final ModifiableEnergyStorage storage = new ModifiableEnergyStorage(64000, 512, 0);
    private final LazyOptional<IEnergyStorage> lazyStorage = LazyOptional.of(() -> this.storage);
    private final LazyOptional<IPipeConnectable> lazyThis = LazyOptional.of(() -> this);
    private int lastEnergy;

    public PressurizerTileEntity() {
        super(Registry.pressurizerTileEntity);
    }

    public boolean pressurizeItem(ItemStack stack, boolean simulate) {
        int amount = 100 * stack.func_190916_E();
        return this.storage.extractInternal(amount, simulate) >= amount;
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergy() / (float)this.getMaxEnergy();
    }

    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("energy", this.getEnergy());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.prettypipes.pressurizer");
    }

    @Nullable
    public Container createMenu(int window, PlayerInventory inv, PlayerEntity player) {
        return new PressurizerContainer(Registry.pressurizerContainer, window, player, this.field_174879_c);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.lazyStorage.cast();
        }
        if (cap == Registry.pipeConnectableCapability) {
            return this.lazyThis.cast();
        }
        return LazyOptional.empty();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.lazyStorage.invalidate();
        this.lazyThis.invalidate();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            PipeNetwork network = PipeNetwork.get(this.field_145850_b);
            for (Direction dir : Direction.values()) {
                BlockPos offset = this.field_174879_c.func_177972_a(dir);
                for (BlockPos node : network.getOrderedNetworkNodes(offset)) {
                    PipeTileEntity pipe;
                    if (!this.field_145850_b.func_175667_e(node) || (pipe = network.getPipe(node)) == null) continue;
                    pipe.pressurizer = this;
                }
            }
        }
        if (this.lastEnergy != this.storage.getEnergyStored() && this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.lastEnergy = this.storage.getEnergyStored();
            Utility.sendTileEntityToClients(this);
        }
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        return ConnectionType.CONNECTED;
    }

    private static class ModifiableEnergyStorage
    extends EnergyStorage {
        public ModifiableEnergyStorage(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        private void setEnergyStored(int energy) {
            this.energy = energy;
        }

        private int extractInternal(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
            }
            return energyExtracted;
        }
    }
}

