/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import com.google.common.base.Preconditions;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.text.TranslationTextComponent;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.ReflectionHelper;
import technicianlp.reauth.gui.AuthScreen;

public final class DisconnectHandler {
    private static final Field managerField = ReflectionHelper.findMcpField(ConnectingScreen.class, "field_146371_g");
    private static final Field previousField;
    private static ConnectingScreen screen;

    public static String getTranslationKey(Object component) {
        if (component instanceof TranslationTextComponent) {
            return ((TranslationTextComponent)component).func_150268_i();
        }
        return "";
    }

    public static void setConnectScreen(ConnectingScreen screen) {
        DisconnectHandler.screen = screen;
    }

    public static boolean canRetryLogin() {
        return screen != null && ReAuth.config.hasCredentials();
    }

    public static void retryLogin() {
        try {
            SocketAddress add;
            ReAuth.auth.login(ReAuth.config.getUsername(), ReAuth.config.getPassword(), true);
            if (screen != null && (add = ((NetworkManager)ReflectionHelper.getField(managerField, screen)).func_74430_c()) instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)add;
                Minecraft client = Minecraft.func_71410_x();
                client.func_147108_a((Screen)new ConnectingScreen((Screen)ReflectionHelper.getField(previousField, screen), client, address.getHostString(), address.getPort()));
            }
        }
        catch (AuthenticationException exception) {
            ReAuth.log.error("Login failed:", (Throwable)exception);
            AuthScreen login = new AuthScreen((Screen)ReflectionHelper.getField(previousField, screen), I18n.func_135052_a((String)"reauth.login.fail", (Object[])new Object[]{exception.getMessage()}));
            Minecraft.func_71410_x().func_147108_a((Screen)login);
        }
    }

    static {
        Preconditions.checkNotNull((Object)managerField, (Object)"Reflection failed: field_146371_g");
        previousField = ReflectionHelper.findMcpField(ConnectingScreen.class, "field_146374_i");
        Preconditions.checkNotNull((Object)previousField, (Object)"Reflection failed: field_146374_i");
    }
}

