/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonNodeConnector
extends DungeonPiece {
    public DungeonNodeConnector() {
        super(StructurePieceTypes.NODE_CONNECTOR);
    }

    public DungeonNodeConnector(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.NODE_CONNECTOR, nbt);
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return true;
        }
        BlockPos pos = new BlockPos(this.x, this.y + this.model.getOffset(this.field_186169_c).func_177956_o(), this.z);
        this.buildRotated(this.model, (IWorld)worldIn, structureBoundingBoxIn, pos, this.theme, this.secondaryTheme, this.stage, this.field_186169_c, this.worldGen, false, false);
        this.placeFeatures((IWorld)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage, this.worldGen);
        this.decorate((IWorld)worldIn, pos, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, this.field_74887_e, this.model, this.worldGen);
        return true;
    }

    @Override
    public int getDungeonPieceType() {
        return 11;
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
        this.model = modelSelector.nodeConnectors.roll(rand);
    }

    public void adjustPositionAndBounds() {
        if (this.model == null) {
            return;
        }
        if (this.field_186169_c == Rotation.NONE || this.field_186169_c == Rotation.CLOCKWISE_180) {
            int minZ = this.z - (this.model.length - 3) / 2;
            this.field_74887_e = new MutableBoundingBox(this.x, this.y, minZ, this.x + 4, this.y + this.model.height - 1, minZ + this.model.length - 1);
        } else {
            int minX = this.x - (this.model.length - 3) / 2;
            this.field_74887_e = new MutableBoundingBox(minX, this.y, this.z, minX + this.model.length - 1, this.y + this.model.height - 1, this.z + 4);
        }
        this.setWorldPosition(this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c);
    }

    @Override
    public void createBoundingBox() {
        if (this.model != null) {
            this.field_74887_e = this.model.createBoundingBoxWithOffset(this.x, this.y, this.z, this.field_186169_c);
        }
    }
}

