/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.monster.RandomMonster;
import xiroc.dungeoncrawl.dungeon.monster.RandomPotionEffect;
import xiroc.dungeoncrawl.dungeon.monster.SpawnRates;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Spawner
implements IBlockPlacementHandler {
    public static final Set<EntityType<?>> INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.field_200725_aD).add((Object)EntityType.field_200741_ag).add((Object)EntityType.field_200763_C).add((Object)EntityType.field_200750_ap).add((Object)EntityType.field_200722_aA).build();
    public static final Set<EntityType<?>> RANGED_INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.field_200741_ag).add((Object)EntityType.field_200750_ap).build();

    @Override
    public void place(IWorld world, BlockState state, BlockPos pos, Random rand, Theme theme, Theme.SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof MobSpawnerTileEntity) {
            MobSpawnerTileEntity tile = (MobSpawnerTileEntity)tileentity;
            EntityType<?> type = RandomMonster.randomMonster(rand, stage);
            tile.func_145881_a().func_200876_a(type);
            if (((Boolean)Config.CUSTOM_SPAWNERS.get()).booleanValue() && INVENTORY_ENTITIES.contains(type)) {
                CompoundNBT spawnerNBT = tile.func_145881_a().func_189530_b(new CompoundNBT());
                ListNBT potentialSpawns = new ListNBT();
                for (int i = 0; i < (Integer)Config.SPAWNER_ENTITIES.get(); ++i) {
                    CompoundNBT nbt = new CompoundNBT();
                    CompoundNBT spawnData = Spawner.createSpawnData(type, null, rand, stage);
                    nbt.func_218657_a("Entity", (INBT)spawnData);
                    nbt.func_74768_a("Weight", 1);
                    if (i == 0) {
                        spawnerNBT.func_218657_a("SpawnData", (INBT)spawnData);
                    }
                    potentialSpawns.add((Object)nbt);
                }
                RandomValueRange delay = SpawnRates.getDelay(stage);
                spawnerNBT.func_218657_a("SpawnPotentials", (INBT)potentialSpawns);
                spawnerNBT.func_74777_a("MinSpawnDelay", (short)delay.func_186509_a());
                spawnerNBT.func_74777_a("MaxSpawnDelay", (short)delay.func_186512_b());
                spawnerNBT.func_74777_a("SpawnCount", (short)SpawnRates.getAmount(stage).func_186511_a(rand));
                spawnerNBT.func_74777_a("RequiredPlayerRange", ((Integer)Config.SPAWNER_RANGE.get()).shortValue());
                tile.func_145881_a().func_98270_a(spawnerNBT);
            }
        } else {
            DungeonCrawl.LOGGER.error("Failed to fetch a mob spawner at ({}, {}, {})", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public static CompoundNBT createSpawnData(@Nullable EntityType<?> type, @Nullable CompoundNBT spawnData, Random rand, int stage) {
        ResourceLocation registryName;
        if (type == null) {
            type = RandomMonster.randomMonster(rand, stage);
        }
        if (spawnData == null) {
            spawnData = new CompoundNBT();
        }
        if ((registryName = type.getRegistryName()) == null) {
            DungeonCrawl.LOGGER.warn("Entity type {} has no registry name.", type);
            return new CompoundNBT();
        }
        spawnData.func_74778_a("id", registryName.toString());
        if (INVENTORY_ENTITIES.contains(type)) {
            ListNBT potionEffects;
            ItemStack mainHand;
            ItemStack[] armor = RandomEquipment.createArmor(rand, stage);
            ListNBT armorList = new ListNBT();
            for (ItemStack stack : armor) {
                armorList.add((Object)stack.func_77955_b(new CompoundNBT()));
            }
            if (armorList.size() > 0) {
                spawnData.func_218657_a("ArmorItems", (INBT)armorList);
            }
            ListNBT handItems = new ListNBT();
            ItemStack itemStack = mainHand = RANGED_INVENTORY_ENTITIES.contains(type) ? RandomEquipment.getRangedWeapon(DungeonBlocks.RANDOM, stage) : RandomEquipment.getMeleeWeapon(DungeonBlocks.RANDOM, stage);
            if (mainHand != ItemStack.field_190927_a) {
                handItems.add((Object)mainHand.func_77955_b(new CompoundNBT()));
            }
            handItems.add((Object)(rand.nextDouble() < 0.25 ? RandomItems.createShield(rand, stage).func_77955_b(new CompoundNBT()) : ItemStack.field_190927_a.func_77955_b(new CompoundNBT())));
            spawnData.func_218657_a("HandItems", (INBT)handItems);
            if (!((Boolean)Config.NATURAL_DESPAWN.get()).booleanValue()) {
                spawnData.func_74757_a("PersistenceRequired", true);
            }
            if ((potionEffects = RandomPotionEffect.createPotionEffects(rand, stage)) != null) {
                spawnData.func_218657_a("ActiveEffects", (INBT)potionEffects);
            }
        }
        if (((Boolean)Config.OVERWRITE_ENTITY_LOOT_TABLES.get()).booleanValue() && RandomMonster.NBT_PATCHERS.containsKey(type)) {
            RandomMonster.NBT_PATCHERS.get(type).patch(spawnData, rand, stage);
        }
        return spawnData;
    }
}

