/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import xiroc.dungeoncrawl.command.argument.SecondaryThemeArgument;
import xiroc.dungeoncrawl.command.argument.ThemeArgument;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.piece.DungeonEntrance;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.theme.Theme;

public class SpawnDungeonCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"roguelike").requires(a -> a.func_197034_c(4))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(command -> {
            BlockPos pos = Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource());
            ServerWorld world = ((CommandSource)command.getSource()).func_197023_e();
            ResourceLocation biomeKey = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)world.func_225526_b_(pos.func_177958_n() >> 2, pos.func_177956_o() >> 2, pos.func_177952_p() >> 2));
            String biome = biomeKey != null ? biomeKey.toString() : "minecraft:plains";
            return SpawnDungeonCommand.spawnDungeon((CommandSource)command.getSource(), world, pos, Theme.randomTheme(biome, world.func_201674_k()), Theme.randomSecondaryTheme(biome, world.func_201674_k()));
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"theme", (ArgumentType)ThemeArgument.theme()).executes(command -> SpawnDungeonCommand.spawnDungeon((CommandSource)command.getSource(), ((CommandSource)command.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource()), ThemeArgument.getTheme((CommandContext<CommandSource>)command, "theme"), Theme.getBuiltinDefaultSecondaryTheme()))).then(Commands.func_197056_a((String)"secondary_theme", (ArgumentType)SecondaryThemeArgument.secondaryTheme()).executes(command -> SpawnDungeonCommand.spawnDungeon((CommandSource)command.getSource(), ((CommandSource)command.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource()), ThemeArgument.getTheme((CommandContext<CommandSource>)command, "theme"), SecondaryThemeArgument.getSecondaryTheme((CommandContext<CommandSource>)command, "secondary_theme")))))));
    }

    private static int spawnDungeon(CommandSource commandSource, ServerWorld world, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme) {
        commandSource.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "This is an experimental feature. Please report any bugs you encounter on the issue tracker on https://github.com/XYROC/DungeonCrawl/issues."), true);
        if (world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p()) > 32) {
            long seed = (long)pos.func_177958_n() + (long)pos.func_177952_p() << (int)(8L + world.func_72905_C());
            commandSource.func_197030_a((ITextComponent)new StringTextComponent("Dungeon Seed: " + seed), true);
            commandSource.func_197030_a((ITextComponent)new StringTextComponent("Building a dungeon..."), true);
            DungeonBuilder builder = new DungeonBuilder(world, pos, new Random(seed));
            builder.theme = theme;
            builder.secondaryTheme = secondaryTheme;
            List<DungeonPiece> pieces = builder.build();
            pieces.forEach(piece -> {
                piece.worldGen = false;
                if (piece instanceof DungeonEntrance) {
                    Vector3i offset = piece.model.getOffset(piece.field_186169_c);
                    int x = piece.x + 4 + offset.func_177958_n();
                    int z = piece.z + 4 + offset.func_177952_p();
                    MutableBoundingBox bounds = new MutableBoundingBox(x, 0, z, x + piece.model.width - 1, world.func_217301_I(), z + piece.model.length - 1);
                    Vector3i vector3i = bounds.func_215126_f();
                    piece.func_230383_a_((ISeedReader)world, world.func_241112_a_(), world.func_72863_F().field_186029_c, builder.rand, bounds, new ChunkPos(piece.x >> 4, piece.z >> 4), new BlockPos(vector3i.func_177958_n(), bounds.field_78895_b, vector3i.func_177952_p()));
                } else {
                    MutableBoundingBox boundingBox = piece.func_74874_b();
                    Vector3i vector3i = boundingBox.func_215126_f();
                    piece.func_230383_a_((ISeedReader)world, world.func_241112_a_(), world.func_72863_F().field_186029_c, builder.rand, boundingBox, new ChunkPos(piece.x >> 4, piece.z >> 4), new BlockPos(vector3i.func_177958_n(), boundingBox.field_78895_b, vector3i.func_177952_p()));
                }
            });
            commandSource.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Done."), true);
            return 0;
        }
        commandSource.func_197021_a((ITextComponent)new StringTextComponent("Your current position is unfit for a dungeon."));
        return 1;
    }
}

