/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.ui;

import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.Drop;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.DropList;
import com.valkyrieofnight.envirotech.m_voidminer.tile.VoidMinerCCUTile;
import com.valkyrieofnight.envirotech.m_voidminer.ui.DropInfoPanel;
import com.valkyrieofnight.envirotech.m_voidminer.ui.VoidMinerGUI;
import com.valkyrieofnight.vlib.core.ui.client.VLScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.scroll.VScrollContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.SideMenuButton;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.client.TextComponentUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class VoidMinerDropGUI
extends VLScreen {
    private SideMenuButton back;
    private VoidMinerGUI home;
    private VScrollContainerElement container;
    private VoidMinerCCUTile tile;

    protected VoidMinerDropGUI(VoidMinerCCUTile tile, PlayerEntity playerEntity, VoidMinerGUI home) {
        super((ITextComponent)new TranslationTextComponent("gui.envirotech.void_miner_drops"));
        this.tile = tile;
        this.home = home;
        this.func_231149_a_(176, 166);
    }

    protected void addElements() {
        int middle = this.xSize / 2;
        this.addElement((IElement)new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_CONTAINER), 0, 0);
        LabelElement title = new LabelElement("title", (ITextComponent)new TranslationTextComponent("label.envirotech.minable_drops"), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        this.addElement((IElement)title, middle, 4);
        title.setHorizontalAlignment(HAlignment.CENTER);
        this.addElement((IElement)new SizablePanelElement("pan", StandardThemeAssets.GSB_VANILLA_ENTITY_VIEW_BG, 158, 146), 4, 16);
        this.addElement((IElement)new SizablePanelElement("bar", StandardThemeAssets.GSB_VANILLA_ENTITY_VIEW_BG, 10, 146), 162, 16);
        this.container = new VScrollContainerElement("box", 166, 144, 8, 15, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_8X7_V_ENA, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_8X7_V_DIS, 2){

            public void addElementsInContainer() {
                DecimalFormat df = new DecimalFormat("0.00");
                DropList dl = null;
                if (VoidMinerDropGUI.this.tile.isFormed()) {
                    dl = VoidMinerDropGUI.this.tile.getDropList();
                }
                if (dl != null) {
                    List<Drop> drops = dl.getAll();
                    int y = 0;
                    for (Drop d : drops) {
                        float percent = (float)d.getWeight() / (float)dl.getTotalWeight() * 100.0f;
                        DropInfoPanel dip = new DropInfoPanel(d, df.format(percent) + "%", VoidMinerDropGUI.this.tile);
                        this.addElement((IElement)dip, 0, y);
                        y += dip.getSizeY();
                    }
                }
            }
        };
        this.addElement((IElement)this.container, 5, 17);
    }

    protected void addElementsPost() {
        super.addElementsPost();
        AssetID col_e = StandardThemeAssets.COL_BUTTON_ICON_ENABLED;
        AssetID col_h = StandardThemeAssets.COL_BUTTON_ICON_HOVER;
        AssetID id = StandardThemeAssets.TEX_SYM_FLAT_48_BACK;
        this.back = new SideMenuButton("back", 12, 12, id, id, id, id);
        this.addElement((IElement)this.back, this.getSideMenuX(), this.getSizeMenuY());
        this.back.addToolTip((ITextComponent)TextComponentUtil.createTranslated((String)"label.valkyrielib.button.back"));
        this.back.setColors(col_e, col_h, col_h, col_h);
        this.nextMenuButton();
    }

    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
        if (element == this.back) {
            Minecraft.func_71410_x().func_147108_a((Screen)this.home);
        }
    }
}

