/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.math.WeightedRandom;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.ingredient.bu.TagIngrediant;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.item.ItemStack;

public class Drop
extends WeightedRandom.Item {
    protected volatile VLID recipeID;
    protected volatile Ingredient<ItemStack> item;
    protected volatile CopyOnWriteArrayList<Integer> tiers;
    protected final int defaultWeight;
    protected CopyOnWriteArrayList<VLID> biomeBlacklist = Lists.newCopyOnWriteArrayList();
    protected ConcurrentMap<VLID, DimBlacklist> dimBlacklist = Maps.newConcurrentMap();

    public Drop(VLID recipeID, Ingredient<ItemStack> item, List<Integer> tiers, int weight) {
        this.recipeID = recipeID;
        this.item = item;
        this.tiers = Lists.newCopyOnWriteArrayList(tiers);
        this.defaultWeight = weight;
    }

    protected void blacklistBiomes(List<VLID> biomes) {
        if (biomes == null) {
            return;
        }
        this.biomeBlacklist.addAll(biomes);
    }

    protected void blacklistDims(List<VLID> dims) {
        if (dims == null) {
            return;
        }
        for (VLID dim : dims) {
            this.dimBlacklist.compute(dim, (k, dimBlacklist1) -> new DimBlacklist((VLID)k));
        }
    }

    protected void blacklistDimBiomes(List<VLID> dims, List<VLID> biomes) {
        if (dims == null || biomes == null) {
            return;
        }
        for (VLID dim : dims) {
            this.dimBlacklist.computeIfAbsent(dim, k -> new DimBlacklist((VLID)k, biomes));
        }
    }

    public boolean isBlacklistedBiome(VLID biome) {
        return biome != null ? this.biomeBlacklist.contains(biome) : false;
    }

    public boolean isBlacklistedDim(VLID dim) {
        return dim != null ? (this.dimBlacklist.containsKey(dim) ? !((DimBlacklist)this.dimBlacklist.get(dim)).hasBiomes() : false) : false;
    }

    public boolean isBlacklistedDimOrBiome(VLID dim, VLID biome) {
        if (this.isBlacklistedBiome(biome)) {
            return true;
        }
        if (dim != null && this.dimBlacklist.containsKey(dim)) {
            return ((DimBlacklist)this.dimBlacklist.get(dim)).isBlacklisted(biome);
        }
        return false;
    }

    public ItemStack getItem(ConditionContainerProvider containerProvider) {
        List items = this.item.request(containerProvider);
        int rand = MathUtil.getRandomRange((Random)new Random(), (int)0, (int)(items.size() - 1));
        return (ItemStack)items.get(rand);
    }

    public Drop copyWithNewWeight(float weightMultiplier) {
        return new Drop(this.recipeID, this.item, this.tiers, (int)((float)this.getWeight() * weightMultiplier));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Drop) {
            return ((Drop)((Object)obj)).recipeID.equals((Object)this.recipeID);
        }
        return false;
    }

    public boolean isValid() {
        return this.item.isValid();
    }

    public int getWeight() {
        TagIngrediant ti;
        if (this.item instanceof TagIngrediant && (ti = (TagIngrediant)this.item).getSelector().hasMultiple()) {
            return this.defaultWeight * ti.getTotalTagEntries();
        }
        return this.defaultWeight;
    }

    public static class DimBlacklist {
        private final VLID dimension;
        private CopyOnWriteArrayList<VLID> biomes;

        public DimBlacklist(VLID dim, List<VLID> biomes) {
            this.dimension = dim;
            this.biomes = new CopyOnWriteArrayList<VLID>(biomes);
        }

        public DimBlacklist(VLID dim) {
            this(dim, Lists.newArrayList());
        }

        public boolean isBlacklisted(VLID biome) {
            if (biome == null) {
                return this.biomes.isEmpty();
            }
            return !this.biomes.isEmpty() ? this.biomes.contains(biome) : true;
        }

        public boolean hasBiomes() {
            return this.biomes.isEmpty();
        }
    }
}

