/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.integration.jei.categories;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.envirocore.EnviroCore;
import com.valkyrieofnight.envirocore.m_machines.m_lens_grinder.MLensGrinderModule;
import com.valkyrieofnight.envirocore.m_machines.m_lens_grinder.dp.LensGrinderRecipe;
import com.valkyrieofnight.envirocore.m_machines.m_lens_grinder.dp.LensGrinderRecipeRegistry;
import com.valkyrieofnight.vlib.core.protection.PlayerID;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.integration.jei.category.VLJEIRecipeCategory;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainerHandler;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;

public class LensGrinderRecipeCategory
extends VLJEIRecipeCategory<LensGrinderRecipe, LensGrinderRecipeRegistry> {
    public static final VLID ID = EnviroCore.id("lens_grinder");
    protected final String localized = LangUtil.toLoc((String)"block.envirocore.lens_grinder");
    protected final IDrawable icon;
    protected final IDrawable bg;
    protected final ConditionContainerProvider ccp;

    public LensGrinderRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, ID, LensGrinderRecipe.class);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)MLensGrinderModule.BLOCK));
        this.bg = guiHelper.createBlankDrawable(160, 50);
        this.ccp = ConditionDataContainerHandler.getInstance().getProvider(this::getDim, this::getPlayerID);
    }

    public LensGrinderRecipeRegistry getRegistry() {
        return MLensGrinderModule.LENS_GRINDER_RECIPE_REGISTRY;
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(LensGrinderRecipe memProgrmRecipe, IIngredients iIngredients) {
        ArrayList ins = Lists.newArrayList();
        ins.add(memProgrmRecipe.getInput(this.ccp));
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)ins);
        iIngredients.setOutputs(VanillaTypes.ITEM, (List)Lists.newArrayList((Object[])new ItemStack[]{memProgrmRecipe.getOutput(this.ccp)}));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, LensGrinderRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup isg = iRecipeLayout.getItemStacks();
        isg.init(0, true, 140, 0);
        isg.init(1, false, 140, 32);
        isg.set(iIngredients);
    }

    private PlayerID getPlayerID() {
        GameProfile gp = Minecraft.func_71410_x().field_71439_g.func_146103_bH();
        return new PlayerID(gp.getId(), gp.getName());
    }

    private DimensionType getDim() {
        return Minecraft.func_71410_x().field_71441_e.func_230315_m_();
    }

    public void draw(LensGrinderRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((Object)recipe, matrixStack, mouseX, mouseY);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        TranslationTextComponent catT = new TranslationTextComponent("label.valkyrielib.generic.category");
        TranslationTextComponent proT = new TranslationTextComponent("label.envirocore.focus_lens");
        TranslationTextComponent cat = new TranslationTextComponent(recipe.getUnlocalizedCategory(0));
        TranslationTextComponent ttl = new TranslationTextComponent(recipe.getUnlocalizedTitle());
        fr.func_243248_b(matrixStack, (ITextComponent)catT, 4.0f, 4.0f, 1);
        fr.func_243248_b(matrixStack, (ITextComponent)cat, 8.0f, 14.0f, 1);
        fr.func_243248_b(matrixStack, (ITextComponent)proT, 4.0f, 28.0f, 1);
        fr.func_243248_b(matrixStack, (ITextComponent)ttl, 8.0f, 38.0f, 1);
    }
}

