/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.items;

import com.flanks255.psu.PSUItemHandler;
import com.flanks255.psu.gui.PSUContainer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PocketStorageUnit
extends Item {
    private final int size;
    private final Rarity rarity;
    private String name;
    private final int capacity;
    private long lastInteractMills = 0L;
    private BlockPos lastInteractPos = new BlockPos(0, 0, 0);

    public PocketStorageUnit(int size, int capacity, Rarity rarity) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
        this.size = size;
        this.rarity = rarity;
        this.capacity = capacity;
    }

    public Rarity func_77613_e(ItemStack p_77613_1_) {
        return this.rarity;
    }

    private boolean hasTranslation(String key) {
        return !I18n.func_135052_a((String)key, (Object[])new Object[0]).equals(key);
    }

    private String fallbackString(String key, String fallback) {
        String tmp = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        return tmp.equals(key) ? fallback : tmp;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String translationKey = this.func_77658_a();
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)(translationKey + ".info"), (Object[])new Object[]{this.size, this.capacity})));
            if (this.hasTranslation(translationKey + ".info2")) {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)(translationKey + ".info2"), (Object[])new Object[0])));
            }
            if (this.hasTranslation(translationKey + ".info3")) {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)(translationKey + ".info3"), (Object[])new Object[0])));
            }
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"pocketstorage.deposit", (Object[])new Object[0])));
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"pocketstorage.withdraw", (Object[])new Object[0])));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(this.fallbackString("pocketstorage.shift", "Press <\u00a76\u00a7oShift\u00a7r> for info.")));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PSUCaps(stack);
    }

    public boolean pickupEvent(EntityItemPickupEvent event, ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return false;
        }
        LazyOptional optional = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (!optional.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)optional.orElse(null);
        if (handler == null || !(handler instanceof PSUItemHandler)) {
            return false;
        }
        ((PSUItemHandler)handler).load();
        ItemStack pickedUp = event.getItem().func_92059_d();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slot = handler.getStackInSlot(i);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot, (ItemStack)pickedUp)) continue;
            handler.insertItem(i, pickedUp, false);
            pickedUp.func_190920_e(0);
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        this.openGUI(worldIn, playerIn, handIn);
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            World world = context.func_195991_k();
            BlockState bs = world.func_180495_p(context.func_195995_a());
            if (bs.hasTileEntity()) {
                TileEntity te = world.func_175625_s(context.func_195995_a());
                LazyOptional chestOptional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                LazyOptional myOptional = context.func_195996_i().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                myOptional.ifPresent(my -> chestOptional.ifPresent(chest -> {
                    if (my instanceof PSUItemHandler) {
                        ((PSUItemHandler)my).load();
                        for (int i = 0; i < my.getSlots(); ++i) {
                            ItemStack stack = my.getStackInSlot(i);
                            if (stack.func_190926_b()) continue;
                            ItemStack backup = my.getStackInSlot(i);
                            backup.func_190920_e(1);
                            stack.func_190920_e(stack.func_190916_E() - 1);
                            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)chest, (ItemStack)stack, (boolean)false);
                            if (remainder.func_190926_b()) {
                                ((PSUItemHandler)my).setStackInSlot(i, backup);
                                continue;
                            }
                            remainder.func_190920_e(remainder.func_190916_E() + 1);
                            ((PSUItemHandler)my).setStackInSlot(i, remainder);
                        }
                    }
                }));
            } else {
                this.openGUI(context.func_195991_k(), context.func_195999_j(), context.func_221531_n());
            }
        }
        return ActionResultType.FAIL;
    }

    public void onLeftClickEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (this.lastInteractPos.compareTo((Vector3i)event.getPos()) != 0) {
            this.onLeftClick(event);
        } else if (System.currentTimeMillis() - this.lastInteractMills > 1000L) {
            this.onLeftClick(event);
        }
        this.lastInteractMills = System.currentTimeMillis();
        this.lastInteractPos = event.getPos();
    }

    private void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world;
        BlockState bs;
        if (!event.getWorld().field_72995_K && (bs = (world = event.getWorld()).func_180495_p(event.getPos())).hasTileEntity()) {
            TileEntity te = world.func_175625_s(event.getPos());
            LazyOptional chestOptional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            LazyOptional myOptional = event.getPlayer().func_184614_ca().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            myOptional.ifPresent(my -> chestOptional.ifPresent(chest -> {
                if (my instanceof PSUItemHandler) {
                    ((PSUItemHandler)my).load();
                    for (int i = 0; i < chest.getSlots(); ++i) {
                        ItemStack stack = chest.getStackInSlot(i);
                        if (stack.func_190926_b() || !((PSUItemHandler)my).hasItem(stack)) continue;
                        ItemStack newstack = chest.extractItem(i, stack.func_190916_E(), false);
                        ((PSUItemHandler)my).insertItemSlotless(newstack, false, false);
                    }
                }
            }));
        }
    }

    private void openGUI(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_184586_b(handIn).func_77973_b() instanceof PocketStorageUnit) {
            playerIn.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, playerEntity) -> new PSUContainer(windowId, playerInventory, null), playerIn.func_184586_b(handIn).func_200301_q()));
        }
    }

    class PSUCaps
    implements ICapabilityProvider {
        private final PSUItemHandler inventory;
        private final LazyOptional<IItemHandler> lazyOptional;

        public PSUCaps(ItemStack stack) {
            this.inventory = new PSUItemHandler(stack, PocketStorageUnit.this.size, PocketStorageUnit.this.capacity);
            this.lazyOptional = LazyOptional.of(() -> this.inventory);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.lazyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

