/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.gui;

import com.flanks255.psu.PSUItemHandler;
import com.flanks255.psu.PocketStorage;
import com.flanks255.psu.items.PocketStorageUnit;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PSUContainer
extends Container {
    public String itemKey;
    public PSUItemHandler handler;
    private final PlayerInventory playerinv;
    protected int slotID;

    public PSUContainer(int windowId, PlayerInventory playerInventory, PacketBuffer extra) {
        this(windowId, playerInventory.field_70458_d.field_70170_p, playerInventory.field_70458_d.func_233580_cy_(), playerInventory, playerInventory.field_70458_d);
    }

    public PSUContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        super((ContainerType)PocketStorage.PSUCONTAINER.get(), windowId);
        this.playerinv = playerInventory;
        ItemStack stack = this.findPSU(player);
        if (stack == null || stack.func_190926_b()) {
            player.func_71053_j();
            return;
        }
        IItemHandler tmp = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        this.itemKey = stack.func_77977_a();
        if (tmp instanceof PSUItemHandler) {
            this.handler = (PSUItemHandler)tmp;
            ((PSUItemHandler)tmp).load();
        } else {
            player.func_71053_j();
        }
        this.addPlayerSlots(playerInventory);
    }

    public ItemStack findPSU(PlayerEntity playerIn) {
        PlayerInventory playerInventory = playerIn.field_71071_by;
        if (playerIn.func_184614_ca().func_77973_b() instanceof PocketStorageUnit) {
            for (int i = 0; i <= 8; ++i) {
                ItemStack stack = playerInventory.func_70301_a(i);
                if (stack != playerIn.func_184614_ca()) continue;
                this.slotID = i;
                return stack;
            }
        } else if (playerIn.func_184592_cb().func_77973_b() instanceof PocketStorageUnit) {
            this.slotID = -106;
            return playerIn.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slot >= 0 && this.func_75139_a(slot).func_75211_c().func_77973_b() instanceof PocketStorageUnit) {
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return ItemStack.field_190927_a;
        }
        if (slot >= 0) {
            this.func_75139_a((int)slot).field_75224_c.func_70296_d();
        }
        return super.func_184996_a(slot, dragType, clickTypeIn, player);
    }

    public void networkSlotClick(int slot, boolean shift, boolean ctrl, boolean rightClick) {
        if (slot >= 0 && slot <= this.handler.getSlots()) {
            if (!this.playerinv.func_70445_o().func_190926_b()) {
                ItemStack tmp;
                ItemStack incoming = this.playerinv.func_70445_o();
                if (incoming.func_77942_o() && this.playerinv.field_70458_d.field_70170_p.func_201670_d()) {
                    this.playerinv.field_70458_d.func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"pocketstorage.nodataitems", (Object[])new Object[0])), this.playerinv.field_70458_d.func_110124_au());
                    return;
                }
                if (rightClick) {
                    ItemStack single = incoming.func_77979_a(1);
                    ItemStack remainder = this.handler.insertItem(slot, single, false);
                    if (!remainder.func_190926_b()) {
                        incoming.func_190917_f(1);
                    }
                    this.playerinv.func_70437_b(incoming);
                } else if (!ctrl) {
                    this.playerinv.func_70437_b(this.handler.insertItem(slot, incoming, false));
                } else if (incoming.func_190916_E() < incoming.func_77976_d() && incoming.func_77969_a(this.handler.getStackInSlot(slot)) && !(tmp = this.handler.extractItem(slot, 1, false)).func_190926_b()) {
                    incoming.func_190920_e(incoming.func_190916_E() + 1);
                    this.playerinv.func_70437_b(incoming);
                }
            } else {
                ItemStack tmp;
                int extract;
                int n = extract = ctrl ? 1 : 64;
                if (rightClick) {
                    extract = Math.min(this.handler.getStackInSlot(slot).func_190916_E() / 2, 32);
                }
                if (!shift) {
                    ItemStack tmp2 = this.handler.extractItem(slot, extract, false);
                    if (!tmp2.func_190926_b()) {
                        this.playerinv.func_70437_b(tmp2);
                    }
                    return;
                }
                if (shift && !(tmp = this.handler.extractItem(slot, extract, false)).func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)this.playerinv.field_70458_d, (ItemStack)tmp);
                }
            }
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        if (this.slotID == -106) {
            return playerIn.func_184592_cb().func_77973_b() instanceof PocketStorageUnit;
        }
        return !playerIn.field_71071_by.func_70301_a(this.slotID).func_190926_b();
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            return this.handler.insertItemSlotless(slot.func_75211_c(), true, true);
        }
        return ItemStack.field_190927_a;
    }

    private void addPlayerSlots(PlayerInventory playerInventory) {
        int originX = 7;
        int originY = 97;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, x + 1, y + 1));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            this.func_75146_a(new Slot((IInventory)playerInventory, col, x + 1, y + 1));
        }
    }
}

