/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu;

import com.flanks255.psu.CopyDataRecipe;
import com.flanks255.psu.data.Generator;
import com.flanks255.psu.gui.PSUContainer;
import com.flanks255.psu.gui.PSUGui;
import com.flanks255.psu.items.PocketStorageUnit;
import com.flanks255.psu.network.PSUNetwork;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pocketstorage")
public class PocketStorage {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "pocketstorage";
    public static SimpleChannel network;
    public static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<ContainerType<?>> CONTAINERS;
    private static final DeferredRegister<IRecipeSerializer<?>> RECIPES;
    public static final RegistryObject<Item> PSU1;
    public static final RegistryObject<Item> PSU2;
    public static final RegistryObject<Item> PSU3;
    public static final RegistryObject<Item> PSU4;
    public static final RegistryObject<ContainerType<PSUContainer>> PSUCONTAINER;
    public static final RegistryObject<IRecipeSerializer<CopyDataRecipe>> UPGRADE_RECIPE;

    public PocketStorage() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        CONTAINERS.register(bus);
        RECIPES.register(bus);
        bus.addListener(Generator::gatherData);
        bus.addListener(this::setup);
        bus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.addListener(this::pickupEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::interactEvent);
    }

    private void pickupEvent(EntityItemPickupEvent event) {
        if (event.getPlayer().field_71070_bA instanceof PSUContainer || event.getPlayer().func_225608_bj_()) {
            return;
        }
        PlayerInventory playerInv = event.getPlayer().field_71071_by;
        for (int i = 0; i <= 35; ++i) {
            ItemStack stack = playerInv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof PocketStorageUnit) || !((PocketStorageUnit)stack.func_77973_b()).pickupEvent(event, stack)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    private void interactEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getItemStack().func_77973_b() instanceof PocketStorageUnit && event.getPlayer().func_225608_bj_()) {
            if (event.getSide() == LogicalSide.SERVER) {
                ((PocketStorageUnit)event.getItemStack().func_77973_b()).onLeftClickEvent(event);
            }
            event.setCanceled(true);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        network = PSUNetwork.getNetworkChannel();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)PSUCONTAINER.get()), PSUGui::new);
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)MODID);
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        PSU1 = ITEMS.register("psu_1", () -> new PocketStorageUnit(8, 255, Rarity.COMMON));
        PSU2 = ITEMS.register("psu_2", () -> new PocketStorageUnit(16, 4095, Rarity.UNCOMMON));
        PSU3 = ITEMS.register("psu_3", () -> new PocketStorageUnit(32, 65535, Rarity.RARE));
        PSU4 = ITEMS.register("psu_4", () -> new PocketStorageUnit(64, 1048575, Rarity.EPIC));
        PSUCONTAINER = CONTAINERS.register("psu_container", () -> IForgeContainerType.create(PSUContainer::new));
        UPGRADE_RECIPE = RECIPES.register("data_upgrade", CopyDataRecipe.Serializer::new);
    }
}

