/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu;

import com.flanks255.psu.PSUSlot;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class PSUItemHandler
implements IItemHandler,
IItemHandlerModifiable {
    private final NonNullList<PSUSlot> slots;
    private final ItemStack itemStack;
    private final int slotCount;
    private final int slotCapacity;

    public PSUItemHandler(ItemStack stack, int slotsCount, int capacity) {
        this.slotCount = slotsCount;
        this.slotCapacity = capacity;
        this.slots = NonNullList.func_191197_a((int)slotsCount, (Object)PSUSlot.EMPTY);
        this.itemStack = stack;
        this.load();
    }

    void checkIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
    }

    public int getSlots() {
        return this.slotCount;
    }

    public int getSlotLimit(int slot) {
        return this.slotCapacity;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.checkIndex(slot);
        if (!((PSUSlot)this.slots.get(slot)).isEmpty() && ((PSUSlot)this.slots.get(slot)).getCount() > 0) {
            ItemStack tmp = ((PSUSlot)this.slots.get(slot)).getStack();
            tmp.func_190920_e(((PSUSlot)this.slots.get(slot)).getCount());
            return tmp;
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasItem(ItemStack stack) {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)((PSUSlot)this.slots.get(i)).getStack(), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.checkIndex(slot);
        this.slots.set(slot, (Object)new PSUSlot(stack));
        this.save();
    }

    public ItemStack insertItemSlotless(@Nonnull ItemStack stack, boolean allowEmpty, boolean allowVoid) {
        if (stack.func_190926_b() || stack.func_77942_o()) {
            return ItemStack.field_190927_a;
        }
        this.load();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)((PSUSlot)this.slots.get(i)).getStack(), (ItemStack)stack)) continue;
            PSUSlot tmp = (PSUSlot)this.slots.get(i);
            int remainder = allowVoid ? 0 : Math.max(tmp.getCount() + stack.func_190916_E() - this.slotCapacity, 0);
            tmp.setCount(Math.min(tmp.getCount() + stack.func_190916_E(), this.slotCapacity));
            this.save();
            ItemStack tmpstack = stack.func_77946_l();
            stack.func_190920_e(remainder);
            return tmpstack;
        }
        if (allowEmpty) {
            for (int n = 0; n < this.slots.size(); ++n) {
                if (!((PSUSlot)this.slots.get(n)).isEmpty()) continue;
                this.slots.set(n, (Object)new PSUSlot(stack));
                this.save();
                ItemStack tmpstack = stack.func_77946_l();
                stack.func_190920_e(0);
                return tmpstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.checkIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.load();
        if (((PSUSlot)this.slots.get(slot)).isEmpty()) {
            if (!simulate) {
                this.slots.set(slot, (Object)new PSUSlot(stack));
                this.save();
            }
            return ItemStack.field_190927_a;
        }
        if (((PSUSlot)this.slots.get((int)slot)).registryName.equals((Object)stack.func_77973_b().getRegistryName())) {
            if (!simulate) {
                PSUSlot tmp = (PSUSlot)this.slots.get(slot);
                tmp.incrementCount(stack.func_190916_E(), this.slotCapacity);
                this.save();
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.checkIndex(slot);
        PSUSlot tmp = (PSUSlot)this.slots.get(slot);
        if (tmp.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack item = tmp.getStack();
        int extract = Math.min(amount, Math.min(tmp.getCount(), item.func_77976_d()));
        item.func_190920_e(extract);
        if (tmp.getCount() <= extract) {
            if (!simulate) {
                this.slots.set(slot, (Object)PSUSlot.EMPTY);
                this.save();
            }
        } else if (!simulate) {
            tmp.decrementCount(extract);
            this.save();
        }
        return item;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.func_77942_o();
    }

    public void save() {
        ListNBT tagList = new ListNBT();
        for (PSUSlot slot : this.slots) {
            if (!slot.isEmpty()) {
                tagList.add((Object)slot.writeNBT());
                continue;
            }
            CompoundNBT tmp = new CompoundNBT();
            tmp.func_74778_a("Item", "");
            tmp.func_74768_a("Count", 0);
            tagList.add((Object)tmp);
        }
        CompoundNBT nbt = this.itemStack.func_196082_o();
        nbt.func_218657_a("Slots", (INBT)tagList);
        this.itemStack.func_77982_d(nbt);
    }

    public void load() {
        if (this.itemStack.func_77942_o()) {
            this.load(this.itemStack.func_77978_p());
        }
    }

    public void load(@Nonnull CompoundNBT nbt) {
        if (nbt.func_74764_b("Slots")) {
            ListNBT tagList = nbt.func_150295_c("Slots", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT itemTag = tagList.func_150305_b(i);
                if (i >= this.slots.size()) continue;
                PSUSlot tmp = new PSUSlot(itemTag);
                this.slots.set(i, (Object)tmp);
            }
        }
    }
}

