/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectIngredient
extends Ingredient {
    public final Item potionItem;
    public final List<EffectInstance> effects;
    public final boolean extraEffects;
    public final boolean higherAmplifier;
    public final boolean higherDuration;

    public EffectIngredient(ItemStack potionStack) {
        this(potionStack.func_77973_b(), PotionUtils.func_185189_a((ItemStack)potionStack), false, true, true);
    }

    public EffectIngredient(ItemStack potionStack, boolean extraEffects, boolean higherAmplifier, boolean higherDuration) {
        this(potionStack.func_77973_b(), PotionUtils.func_185189_a((ItemStack)potionStack), extraEffects, higherAmplifier, higherDuration);
    }

    public EffectIngredient(Item potionItem, List<EffectInstance> effects) {
        this(potionItem, effects, false, true, true);
    }

    public EffectIngredient(Item potionItem, List<EffectInstance> effects, boolean extraEffects, boolean higherAmplifier, boolean higherDuration) {
        super(Stream.empty());
        this.potionItem = potionItem;
        this.effects = ImmutableList.copyOf(effects);
        this.extraEffects = extraEffects;
        this.higherAmplifier = higherAmplifier;
        this.higherDuration = higherDuration;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        ItemStack potion = new ItemStack((IItemProvider)this.potionItem);
        PotionUtils.func_185184_a((ItemStack)potion, this.effects);
        return new ItemStack[]{potion};
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b() || stack.func_77973_b() != this.potionItem) {
            return false;
        }
        ArrayList<EffectInstance> effectsLeft = new ArrayList<EffectInstance>(PotionUtils.func_185189_a((ItemStack)stack));
        for (EffectInstance effect : this.effects) {
            if (effectsLeft.removeIf(left -> left.func_188419_a() == effect.func_188419_a() && (left.func_76458_c() == effect.func_76458_c() || this.higherAmplifier && left.func_76458_c() > effect.func_76458_c()) && (left.func_188419_a().func_76403_b() || left.func_76459_b() == effect.func_76459_b() || this.higherDuration && left.func_76459_b() > effect.func_76459_b()))) continue;
            return false;
        }
        return effectsLeft.isEmpty() || this.extraEffects;
    }

    @Nonnull
    public IntList func_194139_b() {
        ItemStack[] stacks = this.func_193365_a();
        IntArrayList ial = new IntArrayList(stacks.length);
        for (ItemStack stack : stacks) {
            ial.add(RecipeItemHelper.func_194113_b((ItemStack)stack));
        }
        return ial;
    }

    protected void invalidate() {
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean func_203189_d() {
        return this.potionItem == Items.field_190931_a;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.potionItem.getRegistryName().toString());
        JsonArray jsonEffects = new JsonArray();
        for (EffectInstance effect : this.effects) {
            JsonObject effectJson = new JsonObject();
            effectJson.addProperty("potion", effect.func_188419_a().getRegistryName().toString());
            effectJson.addProperty("amplifier", (Number)effect.func_76458_c());
            effectJson.addProperty("duration", (Number)effect.func_76459_b());
            jsonEffects.add((JsonElement)effectJson);
        }
        json.add("effects", (JsonElement)jsonEffects);
        json.addProperty("extraEffects", Boolean.valueOf(this.extraEffects));
        json.addProperty("higherAmplifier", Boolean.valueOf(this.higherAmplifier));
        json.addProperty("higherDuration", Boolean.valueOf(this.higherDuration));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<EffectIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public EffectIngredient parse(@Nonnull PacketBuffer buffer) {
            Item potionItem = (Item)ForgeRegistries.ITEMS.getValue(buffer.func_192575_l());
            if (potionItem == null) {
                potionItem = Items.field_190931_a;
            }
            ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
            int effectsSize = buffer.readInt();
            for (int i = 0; i < effectsSize; ++i) {
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(buffer.func_192575_l());
                if (potion == null) {
                    potion = Effects.field_76424_c;
                }
                int amplifier = buffer.readInt();
                int duration = buffer.readInt();
                effects.add(new EffectInstance(potion, duration, amplifier));
            }
            boolean extraEffects = buffer.readBoolean();
            boolean higherAmplifier = buffer.readBoolean();
            boolean higherDuration = buffer.readBoolean();
            return new EffectIngredient(potionItem, effects, extraEffects, higherAmplifier, higherDuration);
        }

        @Nonnull
        public EffectIngredient parse(JsonObject json) {
            Item potionItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("item").getAsString()));
            if (potionItem == null) {
                potionItem = Items.field_190931_a;
            }
            ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
            for (JsonElement effectJson : json.get("effects").getAsJsonArray()) {
                JsonObject effect = effectJson.getAsJsonObject();
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effect.get("potion").getAsString()));
                if (potion == null) {
                    potion = Effects.field_76424_c;
                }
                int amplifier = effect.get("amplifier").getAsInt();
                int duration = effect.get("duration").getAsInt();
                effects.add(new EffectInstance(potion, duration, amplifier));
            }
            boolean extraEffects = false;
            if (json.has("extraEffects")) {
                extraEffects = json.get("extraEffects").getAsBoolean();
            }
            boolean higherAmplifier = true;
            if (json.has("higherAmplifier")) {
                higherAmplifier = json.get("higherAmplifier").getAsBoolean();
            }
            boolean higherDuration = true;
            if (json.has("higherDuration")) {
                higherDuration = json.get("higherDuration").getAsBoolean();
            }
            return new EffectIngredient(potionItem, effects, extraEffects, higherAmplifier, higherDuration);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull EffectIngredient ingredient) {
            buffer.func_192572_a(ingredient.potionItem.getRegistryName());
            buffer.writeInt(ingredient.effects.size());
            for (EffectInstance effect : ingredient.effects) {
                buffer.func_192572_a(effect.func_188419_a().getRegistryName());
                buffer.writeInt(effect.func_76458_c());
                buffer.writeInt(effect.func_76459_b());
            }
            buffer.writeBoolean(ingredient.extraEffects);
            buffer.writeBoolean(ingredient.higherAmplifier);
            buffer.writeBoolean(ingredient.higherDuration);
        }
    }
}

