/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.save;

import com.flanks255.simplyutilities.configuration.ConfigCache;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class InhibitorManager
extends WorldSavedData {
    public static String NAME = "simplyutilities_inhibitors";
    private final Set<BlockPos> inhibitors = new HashSet<BlockPos>();

    public InhibitorManager() {
        super(NAME);
    }

    public static InhibitorManager get(ServerWorld world) {
        return (InhibitorManager)world.func_217481_x().func_215752_a(InhibitorManager::new, NAME);
    }

    public void addInhibitor(BlockPos pos) {
        this.inhibitors.add(pos);
        this.func_76186_a(true);
    }

    public void removeInhibitor(BlockPos pos) {
        this.inhibitors.remove(pos);
        this.func_76186_a(true);
    }

    public void removeInhibitors(Set<BlockPos> remSet) {
        this.inhibitors.removeAll(remSet);
        this.func_76186_a(true);
    }

    public Set<BlockPos> getInhibitors() {
        return this.inhibitors;
    }

    public boolean InhibitorCloseEnough(BlockPos teleporterPos) {
        double threshhold = ConfigCache.EnderInhibitorRange;
        for (BlockPos inhibitor : this.inhibitors) {
            if (!(inhibitor.func_177951_i((Vector3i)teleporterPos) < threshhold * threshhold)) continue;
            return true;
        }
        return false;
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("Inhibitors")) {
            this.inhibitors.clear();
            ListNBT positions = nbt.func_150295_c("Inhibitors", 4);
            positions.forEach(pos -> this.inhibitors.add(BlockPos.func_218283_e((long)((LongNBT)pos).func_150291_c())));
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT poslist = new ListNBT();
        this.inhibitors.forEach(pos -> poslist.add((Object)LongNBT.func_229698_a_((long)pos.func_218275_a())));
        compound.func_218657_a("Inhibitors", (INBT)poslist);
        return compound;
    }
}

