/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.render;

import com.flanks255.simplyutilities.render.OnlineDetectorModel;
import com.flanks255.simplyutilities.tile.TEOnlineDetector;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class OnlineDetectorRender
extends TileEntityRenderer<TEOnlineDetector> {
    private static final ResourceLocation OFF_TEXTURE = new ResourceLocation("simplyutilities", "textures/tile/onlinedetectoroff.png");
    private static final ResourceLocation ON_TEXTURE = new ResourceLocation("simplyutilities", "textures/tile/onlinedetectoron.png");
    private final OnlineDetectorModel model = new OnlineDetectorModel();

    public OnlineDetectorRender(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TEOnlineDetector tileEntityIn, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn == null || !tileEntityIn.func_145830_o()) {
            return;
        }
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)(tileEntityIn.onlineState ? ON_TEXTURE : OFF_TEXTURE)));
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        switch ((Direction)tileEntityIn.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case NORTH: {
                matrixStack.func_227861_a_(0.0, 1.0, -1.0);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227861_a_(1.0, 1.0, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                break;
            }
            case EAST: {
                matrixStack.func_227861_a_(-1.0, 1.0, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(270.0f));
                break;
            }
            case SOUTH: {
                matrixStack.func_227861_a_(0.0, 1.0, 1.0);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
                break;
            }
            case DOWN: {
                matrixStack.func_227861_a_(0.0, 2.0, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                break;
            }
        }
        float angle1 = tileEntityIn.ringAngle + (tileEntityIn.ringAngle - tileEntityIn.prevRingAngle) * partialTicks;
        float angle2 = -angle1;
        float eyeInterpolated = (float)tileEntityIn.baseEyeAngle + MathHelper.func_219799_g((float)partialTicks, (float)tileEntityIn.prevEyeOffset, (float)tileEntityIn.currentEyeOffset);
        this.model.ArmAndStand.func_228308_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_);
        this.model.Base.func_228308_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_);
        this.model.bone.func_228308_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.05, 0.0, -0.1);
        matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(-7.5f));
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(angle1));
        this.model.Ring1.func_228308_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.05, 0.0, 0.1);
        matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(7.5f));
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(angle2));
        this.model.Ring2.func_228308_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        if (tileEntityIn.onlineState) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(eyeInterpolated));
        }
        this.model.Eye.func_228308_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }
}

