/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.network;

import com.flanks255.simplyutilities.tweaks.DoubleDoorFix;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class OpenOtherDoorMessage {
    private final BlockPos blockPos;

    public OpenOtherDoorMessage(BlockPos pos) {
        this.blockPos = pos;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public static OpenOtherDoorMessage decode(PacketBuffer buffer) {
        return new OpenOtherDoorMessage(buffer.func_179259_c());
    }

    public static void encode(OpenOtherDoorMessage message, PacketBuffer buffer) {
        buffer.func_179255_a(message.blockPos);
    }

    public static void handle(OpenOtherDoorMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                World world = player.func_130014_f_();
                DoubleDoorFix.openOtherDoor(world, message.getBlockPos());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

