/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.commands;

import com.flanks255.simplyutilities.blocks.EnderInhibitor;
import com.flanks255.simplyutilities.save.InhibitorManager;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class Inhibitor {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"inhibitor").then(Commands.func_197057_a((String)"list").executes(Inhibitor::list))).then(Commands.func_197057_a((String)"check-orphans").executes(Inhibitor::checkOrphans));
    }

    public static int list(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        ServerWorld world = player.func_71121_q();
        Set<BlockPos> inhibitors = InhibitorManager.get(world).getInhibitors();
        if (inhibitors.isEmpty()) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("[ ]"), false);
        } else {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent(inhibitors.toString()), false);
        }
        return 0;
    }

    public static int checkOrphans(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        ServerWorld world = player.func_71121_q();
        InhibitorManager inhibitorManager = InhibitorManager.get(world);
        Set<BlockPos> inhibitors = inhibitorManager.getInhibitors();
        HashSet<BlockPos> removeset = new HashSet<BlockPos>();
        for (BlockPos inhibitor : inhibitors) {
            if (world.func_180495_p(inhibitor).func_177230_c() instanceof EnderInhibitor) continue;
            removeset.add(inhibitor);
        }
        if (!removeset.isEmpty()) {
            inhibitorManager.removeInhibitors(removeset);
        }
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.su.inhibitororphans", new Object[]{removeset.size()}), false);
        return 0;
    }
}

