/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.capabilities;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SUFluidHandler
implements IFluidHandler {
    UUID uuid;
    int capacity;
    private FluidStack storedFluid = FluidStack.EMPTY;

    public SUFluidHandler(UUID uuid, int capacity) {
        this.uuid = uuid;
        this.capacity = capacity;
    }

    public SUFluidHandler(UUID uuid) {
        this.uuid = uuid;
        this.capacity = 8000;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("UUID", this.uuid);
        nbt.func_74768_a("Capacity", this.capacity);
        if (!this.storedFluid.isEmpty()) {
            CompoundNBT fluidnbt = new CompoundNBT();
            this.storedFluid.writeToNBT(fluidnbt);
            nbt.func_218657_a("Fluid", (INBT)fluidnbt);
        }
        return nbt;
    }

    public static LazyOptional<SUFluidHandler> fromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("UUID") && nbt.func_74764_b("Capacity")) {
            SUFluidHandler canHandler = new SUFluidHandler(nbt.func_186857_a("UUID"), nbt.func_74762_e("Capacity"));
            canHandler.setStoredFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("Fluid")));
            return LazyOptional.of(() -> canHandler);
        }
        return LazyOptional.empty();
    }

    public void setStoredFluid(FluidStack stack) {
        this.storedFluid = stack == null ? FluidStack.EMPTY : stack.copy();
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.storedFluid;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int filled = 0;
        if (this.storedFluid.isEmpty()) {
            filled = Math.min(this.capacity, resource.getAmount());
            if (action.execute()) {
                this.storedFluid = resource.copy();
                this.storedFluid.setAmount(filled);
            }
        } else if (resource.isFluidEqual(this.storedFluid)) {
            filled = Math.min(resource.getAmount() + this.storedFluid.getAmount(), this.capacity) - this.storedFluid.getAmount();
            if (action.execute()) {
                this.storedFluid.grow(filled);
            }
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.storedFluid.isEmpty() && resource.isFluidEqual(this.storedFluid)) {
            int drained = Math.min(this.storedFluid.getAmount(), resource.getAmount());
            FluidStack drainedFluid = this.storedFluid.copy();
            drainedFluid.setAmount(drained);
            if (action.execute()) {
                this.storedFluid.shrink(drained);
            }
            return drainedFluid;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.storedFluid.isEmpty()) {
            int drained = Math.min(this.storedFluid.getAmount(), maxDrain);
            FluidStack drainedFluid = this.storedFluid.copy();
            drainedFluid.setAmount(drained);
            if (action.execute()) {
                this.storedFluid.shrink(drained);
            }
            return drainedFluid;
        }
        return FluidStack.EMPTY;
    }
}

