/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile;

import com.refinedmods.refinedstorage.RSTiles;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkManager;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.NetworkType;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.Network;
import com.refinedmods.refinedstorage.apiimpl.network.node.RootNetworkNode;
import com.refinedmods.refinedstorage.block.ControllerBlock;
import com.refinedmods.refinedstorage.capability.NetworkNodeProxyCapability;
import com.refinedmods.refinedstorage.tile.BaseTile;
import com.refinedmods.refinedstorage.tile.ClientNode;
import com.refinedmods.refinedstorage.tile.config.IRedstoneConfigurable;
import com.refinedmods.refinedstorage.tile.config.RedstoneMode;
import com.refinedmods.refinedstorage.tile.data.RSSerializers;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.Direction;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ControllerTile
extends BaseTile
implements INetworkNodeProxy<RootNetworkNode>,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer, ControllerTile> REDSTONE_MODE = RedstoneMode.createParameter();
    public static final TileDataParameter<Integer, ControllerTile> ENERGY_USAGE = new TileDataParameter<Integer, ControllerTile>(DataSerializers.field_187192_b, 0, t -> t.getNetwork().getEnergyUsage());
    public static final TileDataParameter<Integer, ControllerTile> ENERGY_STORED = new TileDataParameter<Integer, ControllerTile>(DataSerializers.field_187192_b, 0, t -> t.getNetwork().getEnergyStorage().getEnergyStored());
    public static final TileDataParameter<Integer, ControllerTile> ENERGY_CAPACITY = new TileDataParameter<Integer, ControllerTile>(DataSerializers.field_187192_b, 0, t -> t.getNetwork().getEnergyStorage().getMaxEnergyStored());
    public static final TileDataParameter<List<ClientNode>, ControllerTile> NODES = new TileDataParameter<List, ControllerTile>(RSSerializers.CLIENT_NODE_SERIALIZER, new ArrayList(), ControllerTile::collectClientNodes);
    private static final String NBT_ENERGY_TYPE = "EnergyType";
    private final LazyOptional<IEnergyStorage> energyProxyCap = LazyOptional.of(() -> this.getNetwork().getEnergyStorage());
    private final LazyOptional<INetworkNodeProxy<RootNetworkNode>> networkNodeProxyCap = LazyOptional.of(() -> this);
    private final NetworkType type;
    private INetwork removedNetwork;
    private Network dummyNetwork;

    public ControllerTile(NetworkType type) {
        super(type == NetworkType.CREATIVE ? RSTiles.CREATIVE_CONTROLLER : RSTiles.CONTROLLER);
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.dataManager.addWatchedParameter(ENERGY_USAGE);
        this.dataManager.addWatchedParameter(ENERGY_STORED);
        this.dataManager.addParameter(ENERGY_CAPACITY);
        this.dataManager.addParameter(NODES);
        this.type = type;
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        super.writeUpdate(tag);
        tag.func_74768_a(NBT_ENERGY_TYPE, ((Network)this.getNetwork()).getEnergyType().ordinal());
        return tag;
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        if (tag.func_74764_b(NBT_ENERGY_TYPE)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(ControllerBlock.ENERGY_TYPE, (Comparable)((Object)ControllerBlock.EnergyType.values()[tag.func_74762_e(NBT_ENERGY_TYPE)])));
        }
        super.readUpdate(tag);
    }

    public INetwork getNetwork() {
        if (this.field_145850_b.field_72995_K) {
            if (this.dummyNetwork == null) {
                this.dummyNetwork = new Network(this.field_145850_b, this.field_174879_c, this.type);
            }
            return this.dummyNetwork;
        }
        INetwork network = API.instance().getNetworkManager((ServerWorld)this.field_145850_b).getNetwork(this.field_174879_c);
        if (network == null) {
            throw new IllegalStateException("No network present at " + this.field_174879_c);
        }
        return network;
    }

    public void func_145829_t() {
        INetworkManager manager;
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && (manager = API.instance().getNetworkManager((ServerWorld)this.field_145850_b)).getNetwork(this.field_174879_c) == null) {
            manager.setNetwork(this.field_174879_c, new Network(this.field_145850_b, this.field_174879_c, this.type));
            manager.markForSaving();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            INetwork network;
            INetworkManager manager = API.instance().getNetworkManager((ServerWorld)this.field_145850_b);
            this.removedNetwork = network = manager.getNetwork(this.field_174879_c);
            manager.removeNetwork(this.field_174879_c);
            manager.markForSaving();
            network.onRemoved();
        }
    }

    public INetwork getRemovedNetwork() {
        return this.removedNetwork;
    }

    @Override
    @Nonnull
    public RootNetworkNode getNode() {
        return ((Network)this.getNetwork()).getRoot();
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return ((Network)this.getNetwork()).getRedstoneMode();
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        ((Network)this.getNetwork()).setRedstoneMode(mode);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyProxyCap.cast();
        }
        if (cap == NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY) {
            return this.networkNodeProxyCap.cast();
        }
        return super.getCapability(cap, direction);
    }

    private static List<ClientNode> collectClientNodes(ControllerTile tile) {
        ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
        for (INetworkNodeGraphEntry entry : tile.getNetwork().getNodeGraph().all()) {
            ItemStack stack;
            if (!entry.getNode().isActive() || (stack = entry.getNode().getItemStack()).func_190926_b()) continue;
            ClientNode clientNode = new ClientNode(stack, 1, entry.getNode().getEnergyUsage());
            if (nodes.contains(clientNode)) {
                ClientNode other = (ClientNode)nodes.get(nodes.indexOf(clientNode));
                other.setAmount(other.getAmount() + 1);
                continue;
            }
            nodes.add(clientNode);
        }
        nodes.sort((a, b) -> Integer.compare(b.getEnergyUsage(), a.getEnergyUsage()));
        return nodes;
    }
}

