/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.tile.StorageMonitorTile;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.RedstoneMode;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class StorageMonitorNetworkNode
extends NetworkNode
implements IComparable,
IType {
    public static final int DEPOSIT_ALL_MAX_DELAY = 500;
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "storage_monitor");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private final BaseItemHandler itemFilter = new BaseItemHandler(1).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!reading) {
            WorldUtils.updateBlock(this.world, this.pos);
        }
    });
    private final FluidInventory fluidFilter = new FluidInventory(1, 1000).addListener((handler, slot, reading) -> {
        if (!reading) {
            WorldUtils.updateBlock(this.world, this.pos);
        }
    });
    private final Map<String, Pair<ItemStack, Long>> deposits = new HashMap<String, Pair<ItemStack, Long>>();
    private int compare = 1;
    private int type = 0;
    private int oldAmount = -1;

    public StorageMonitorNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public void update() {
        super.update();
        if (!this.canUpdate()) {
            return;
        }
        int newAmount = this.getAmount();
        if (this.oldAmount == -1) {
            this.oldAmount = newAmount;
        } else if (this.oldAmount != newAmount) {
            this.oldAmount = newAmount;
            WorldUtils.updateBlock(this.world, this.pos);
        }
    }

    public ActionResultType depositAll(PlayerEntity player) {
        if (this.getType() != 0) {
            return ActionResultType.FAIL;
        }
        if (this.network == null) {
            return ActionResultType.FAIL;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return ActionResultType.FAIL;
        }
        Pair<ItemStack, Long> deposit = this.deposits.get(player.func_146103_bH().getName());
        if (deposit == null) {
            return ActionResultType.FAIL;
        }
        ItemStack inserted = (ItemStack)deposit.getKey();
        long insertedAt = (Long)deposit.getValue();
        if (System.currentTimeMillis() - insertedAt < 500L) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack toInsert = player.field_71071_by.func_70301_a(i);
                if (!API.instance().getComparer().isEqual(inserted, toInsert, this.compare)) continue;
                player.field_71071_by.func_70299_a(i, this.network.insertItemTracked(toInsert, toInsert.func_190916_E()));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType deposit(PlayerEntity player, ItemStack toInsert) {
        if (this.network == null) {
            return ActionResultType.FAIL;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return ActionResultType.FAIL;
        }
        if (this.getType() == 0) {
            this.depositItems(player, toInsert);
        } else if (this.getType() == 1) {
            this.depositFluids(player, toInsert);
        }
        return ActionResultType.SUCCESS;
    }

    private void depositItems(PlayerEntity player, ItemStack toInsert) {
        ItemStack filter = this.itemFilter.getStackInSlot(0);
        if (!filter.func_190926_b() && API.instance().getComparer().isEqual(filter, toInsert, this.compare)) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.network.insertItemTracked(toInsert, toInsert.func_190916_E()));
            this.deposits.put(player.func_146103_bH().getName(), (Pair<ItemStack, Long>)Pair.of((Object)toInsert, (Object)System.currentTimeMillis()));
        }
    }

    private void depositFluids(PlayerEntity player, ItemStack toInsert) {
        FluidStack filter = this.fluidFilter.getFluid(0);
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(toInsert, true);
        if (filter.isEmpty() || !API.instance().getComparer().isEqual(filter, (FluidStack)result.getRight(), this.compare)) {
            return;
        }
        if (!((FluidStack)result.getValue()).isEmpty() && this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.SIMULATE).isEmpty()) {
            this.network.getFluidStorageTracker().changed(player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(toInsert, false);
            this.network.insertFluidTracked((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount());
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            ItemStack container = (ItemStack)result.getLeft();
            if (!player.field_71071_by.func_70441_a(container.func_77946_l())) {
                InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)container);
            }
        }
    }

    public void extract(PlayerEntity player, Direction side) {
        if (this.network == null || this.getDirection() != side) {
            return;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        if (this.getType() == 0) {
            this.extractItems(player);
        } else if (this.getType() == 1) {
            this.extractFluids(player);
        }
    }

    private void extractItems(PlayerEntity player) {
        ItemStack result;
        int toExtract;
        ItemStack filter = this.itemFilter.getStackInSlot(0);
        int n = toExtract = player.func_213453_ef() ? 1 : filter.func_77976_d();
        if (!(filter.func_190926_b() || (result = this.network.extractItem(filter, toExtract, this.compare, Action.PERFORM)).func_190926_b() || player.field_71071_by.func_70441_a(result.func_77946_l()))) {
            InventoryHelper.func_180173_a((World)this.world, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)result);
        }
    }

    private void extractFluids(PlayerEntity player) {
        FluidStack filter = this.fluidFilter.getFluid(0);
        if (filter.isEmpty()) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getList().get(filter);
        if (stack == null || stack.getAmount() < 1000) {
            return;
        }
        boolean shift = player.func_213453_ef();
        if (shift) {
            NetworkUtils.extractBucketFromPlayerInventoryOrNetwork(player, this.network, bucket -> bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(fluidHandler -> {
                this.network.getFluidStorageTracker().changed(player, stack.copy());
                fluidHandler.fill(this.network.extractFluid(stack, 1000, Action.PERFORM), IFluidHandler.FluidAction.EXECUTE);
                if (!player.field_71071_by.func_70441_a(fluidHandler.getContainer().func_77946_l())) {
                    InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)fluidHandler.getContainer());
                }
            }));
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getStorageMonitor().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        WorldUtils.updateBlock(this.world, this.pos);
        this.markDirty();
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilter, 0, tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilter.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems(this.itemFilter, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilter.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public int getAmount() {
        if (this.network == null) {
            return 0;
        }
        if (this.getType() == 0) {
            ItemStack toCheck = this.itemFilter.getStackInSlot(0);
            if (toCheck.func_190926_b()) {
                return 0;
            }
            ItemStack stored = this.network.getItemStorageCache().getList().get(toCheck, this.compare);
            return stored != null ? stored.func_190916_E() : 0;
        }
        if (this.getType() == 1) {
            FluidStack toCheck = this.fluidFilter.getFluid(0);
            if (toCheck.isEmpty()) {
                return 0;
            }
            FluidStack stored = this.network.getFluidStorageCache().getList().get(toCheck, this.compare);
            return stored != null ? stored.getAmount() : 0;
        }
        return 0;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? StorageMonitorTile.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        WorldUtils.updateBlock(this.world, this.pos);
        this.markDirty();
    }

    public BaseItemHandler getItemFilters() {
        return this.itemFilter;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilter;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }
}

