/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.googlyeyes.common.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.ichun.mods.googlyeyes.common.GooglyEyes;
import me.ichun.mods.googlyeyes.common.model.ModelGooglyEye;
import me.ichun.mods.googlyeyes.common.tracker.GooglyTracker;
import me.ichun.mods.ichunutil.api.common.head.HeadInfo;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class LayerGooglyEyes<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final ResourceLocation TEX_GOOGLY_EYE = new ResourceLocation("googlyeyes", "textures/model/modelgooglyeye.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228638_b_((ResourceLocation)TEX_GOOGLY_EYE);
    private static final RenderType RENDER_TYPE_EYES = RenderType.func_228652_i_((ResourceLocation)TEX_GOOGLY_EYE);
    private final ModelGooglyEye modelGooglyEye = new ModelGooglyEye();

    public LayerGooglyEyes() {
        super((IEntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_178637_m);
    }

    public void render(MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        HeadInfo parentHelper = HeadHandler.getHelper(living.getClass());
        if (parentHelper != null) {
            EntityRenderer render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)living);
            if (!(render instanceof LivingRenderer)) {
                return;
            }
            LivingRenderer renderer = (LivingRenderer)render;
            if (!parentHelper.setup(living, renderer)) {
                return;
            }
            GooglyTracker tracker = GooglyEyes.eventHandler.getGooglyTracker(living, parentHelper);
            tracker.setLastUpdateRequest();
            if (!tracker.shouldRender()) {
                return;
            }
            tracker.requireUpdate();
            int headCount = parentHelper.getHeadCount(living);
            for (int headIndex = 0; headIndex < headCount; ++headIndex) {
                HeadInfo helper = parentHelper.getHeadInfo(living, headIndex);
                if (helper.noFaceInfo.booleanValue()) continue;
                helper.setHeadModel(living, renderer);
                if (helper.headModel == null) continue;
                stack.func_227860_a_();
                helper.correctPosition(living, stack, partialTicks);
                int eyeCount = helper.getEyeCount(living);
                for (int eyeIndex = 0; eyeIndex < eyeCount; ++eyeIndex) {
                    float eyeScale;
                    if (living.func_82150_aj() && helper.affectedByInvisibility(living, eyeIndex) || (eyeScale = helper.getEyeScale(living, stack, partialTicks, eyeIndex)) <= 0.0f) continue;
                    stack.func_227860_a_();
                    helper.preChildEntHeadRenderCalls(living, stack, renderer);
                    float[] joint = helper.getHeadJointOffset(living, stack, partialTicks, headIndex);
                    stack.func_227861_a_((double)(-joint[0]), (double)(-joint[1]), (double)(-joint[2]));
                    stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(helper.getHeadRoll(living, stack, partialTicks, headIndex, eyeIndex)));
                    stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(helper.getHeadYaw(living, stack, partialTicks, headIndex, eyeIndex)));
                    stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(helper.getHeadPitch(living, stack, partialTicks, headIndex, eyeIndex)));
                    helper.postHeadTranslation(living, stack, partialTicks);
                    float[] eyes = helper.getEyeOffsetFromJoint(living, stack, partialTicks, eyeIndex);
                    stack.func_227861_a_((double)(-(eyes[0] + helper.getEyeSideOffset(living, stack, partialTicks, eyeIndex))), (double)(-eyes[1]), (double)(-eyes[2]));
                    stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(helper.getEyeRotation(living, stack, partialTicks, eyeIndex)));
                    stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(helper.getEyeTopRotation(living, stack, partialTicks, eyeIndex)));
                    stack.func_227862_a_(eyeScale, eyeScale, eyeScale * 0.4f);
                    IVertexBuilder buffer = bufferIn.getBuffer(RENDER_TYPE);
                    int overlay = LivingRenderer.func_229117_c_((LivingEntity)living, (float)0.0f);
                    float[] corneaColours = helper.getCorneaColours(living, stack, partialTicks, eyeIndex);
                    this.modelGooglyEye.renderCornea(stack, buffer, packedLightIn, overlay, corneaColours[0], corneaColours[1], corneaColours[2], 1.0f);
                    float[] irisColours = helper.getIrisColours(living, stack, partialTicks, eyeIndex);
                    float irisScale = helper.getIrisScale(living, stack, partialTicks, eyeIndex);
                    stack.func_227860_a_();
                    stack.func_227862_a_(irisScale, irisScale, 1.0f);
                    this.modelGooglyEye.moveIris(tracker.eyes[headIndex][eyeIndex].prevDeltaX + (tracker.eyes[headIndex][eyeIndex].deltaX - tracker.eyes[headIndex][eyeIndex].prevDeltaX) * partialTicks, tracker.eyes[headIndex][eyeIndex].prevDeltaY + (tracker.eyes[headIndex][eyeIndex].deltaY - tracker.eyes[headIndex][eyeIndex].prevDeltaY) * partialTicks, irisScale);
                    this.modelGooglyEye.renderIris(stack, buffer, packedLightIn, overlay, irisColours[0], irisColours[1], irisColours[2], 1.0f);
                    stack.func_227865_b_();
                    if (helper.doesEyeGlow(living, eyeIndex)) {
                        buffer = bufferIn.getBuffer(RENDER_TYPE_EYES);
                        this.modelGooglyEye.renderCornea(stack, buffer, packedLightIn, overlay, corneaColours[0], corneaColours[1], corneaColours[2], 1.0f);
                        stack.func_227860_a_();
                        stack.func_227862_a_(irisScale, irisScale, 1.0f);
                        this.modelGooglyEye.renderIris(stack, buffer, packedLightIn, overlay, irisColours[0], irisColours[1], irisColours[2], 1.0f);
                        stack.func_227865_b_();
                    }
                    stack.func_227865_b_();
                }
                stack.func_227865_b_();
            }
        }
    }
}

