/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.server.ServerWorld;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.catalysts.PowderedCatalyst;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.UpdatingTileEntity;
import stepsword.mahoutsukai.util.UnorderedList;

public class MahoujinTileEntity
extends UpdatingTileEntity {
    private UUID casterUUID;
    private boolean cloth;
    private boolean fay;
    public static final String ORDER_TAG = "catalyst_order";
    public static final String CASTER_ID = "caster_uuid";
    public static final String CLOTH_BOOLEAN = "cloth";
    public static final String FAY_TAG = "fay";
    private UnorderedList catalysts;

    public MahoujinTileEntity() {
        super(ModTileEntities.mahoujin);
    }

    public MahoujinTileEntity(TileEntityType type) {
        super(type);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT order = new CompoundNBT();
        if (this.catalysts == null) {
            this.catalysts = new UnorderedList();
        }
        ArrayList<String> orderList = this.catalysts.getOrder();
        for (int i = 0; i < orderList.size(); ++i) {
            order.func_74778_a("" + i, orderList.get(i));
        }
        compound.func_218657_a(ORDER_TAG, (INBT)order);
        compound.func_74757_a(FAY_TAG, this.fay);
        if (this.casterUUID != null) {
            compound.func_186854_a(CASTER_ID, this.casterUUID);
        }
        compound.func_74757_a(CLOTH_BOOLEAN, this.cloth);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ArrayList<String> order = new ArrayList<String>();
        CompoundNBT orderTag = (CompoundNBT)compound.func_74781_a(ORDER_TAG);
        for (int i = 0; i < orderTag.func_150296_c().size(); ++i) {
            order.add(orderTag.func_74779_i("" + i));
        }
        this.catalysts = new UnorderedList(order);
        this.casterUUID = compound.func_186857_a(CASTER_ID);
        this.cloth = compound.func_74767_n(CLOTH_BOOLEAN);
        this.fay = compound.func_74767_n(FAY_TAG);
        super.func_230337_a_(state, compound);
    }

    public UnorderedList getCatalysts() {
        return this.catalysts;
    }

    public void setCatalysts(UnorderedList catalysts) {
        this.catalysts = catalysts;
        this.sendUpdates();
    }

    public int getNumCatalysts() {
        return this.catalysts == null ? 0 : this.catalysts.size();
    }

    public boolean addCatalyst(PowderedCatalyst catalyst) {
        if (this.catalysts == null) {
            this.catalysts = new UnorderedList();
        }
        if (this.catalysts.size() >= 3) {
            this.sendUpdates();
            return false;
        }
        this.catalysts.add(catalyst.getCatalystName(), true);
        this.sendUpdates();
        return true;
    }

    public PlayerEntity getCaster() {
        if (this.casterUUID == null || this.casterUUID.equals(UUID.fromString("00000000-0000-0000-0000-000000000000")) || this.casterUUID.equals(FaeEssence.faeID)) {
            return null;
        }
        if (this.field_145850_b instanceof ServerWorld && this.field_145850_b.func_73046_m() != null) {
            return this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.casterUUID);
        }
        if (this.field_145850_b != null) {
            return this.field_145850_b.func_217371_b(this.casterUUID);
        }
        return null;
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public void setCasterUUID(UUID casterUUID) {
        this.casterUUID = casterUUID;
        this.sendUpdates();
    }

    public void setCaster(PlayerEntity caster) {
        this.casterUUID = caster.func_110124_au();
        this.sendUpdates();
    }

    public boolean hasCloth() {
        return this.cloth;
    }

    public void setCloth(boolean c) {
        this.cloth = c;
    }

    public boolean isFay() {
        return this.fay;
    }

    public void setFay(boolean c) {
        this.fay = c;
    }
}

