/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import stepsword.mahoutsukai.block.MahoujinProjector;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.overlay.RenderInterestingBlock;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.util.ClientImageDownloadUtil;
import stepsword.mahoutsukai.util.EffectUtil;

public class MahoujinProjectorRenderer
extends TileEntityRenderer<MahoujinProjectorTileEntity> {
    public static int rindex = 0;
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");
    private static final ResourceLocation runes = new ResourceLocation("mahoutsukai:textures/block/runes.png");

    public MahoujinProjectorRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(MahoujinProjectorTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int i, int i1) {
        RenderType type;
        ItemStack stack;
        if (te.func_145831_w() != null && te.func_145831_w().func_175640_z(te.func_174877_v())) {
            return;
        }
        if (rindex == 0x7FFFFFFD) {
            rindex = 0;
        }
        if ((stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca()).func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof MahoujinProjector) {
            RenderInterestingBlock.renderBox(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 220, 220, 10, 255);
        }
        float offsetx = te.getCx();
        float offsety = te.getCy();
        float offsetz = te.getCz();
        float r = (float)te.getCr() / 255.0f;
        float g = (float)te.getCg() / 255.0f;
        float b = (float)te.getCb() / 255.0f;
        float a = (float)te.getCa() / 255.0f;
        float rotation = te.getRotation();
        float yaw = te.getCyaw();
        float pitch = te.getCpitch();
        float speed = te.getCspeed();
        float ring = te.getCringangle();
        float size = te.getCsize();
        yaw = yaw - te.getCyspeed() + te.getCyspeed() * partialTicks;
        pitch = pitch - te.getCpspeed() + te.getCpspeed() * partialTicks;
        rotation = te.getRotationOffset() + (rotation - speed) + speed * partialTicks;
        matrix.func_227860_a_();
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        float preyaw = te.getCpreyaw();
        float prepitch = te.getCprepitch();
        float orbit = te.getCorbit() - te.getCorbitspeed() + te.getCorbitspeed() * partialTicks;
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(prepitch));
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(preyaw));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(orbit));
        matrix.func_227861_a_((double)offsetx, (double)offsety, (double)offsetz);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        int loadImage = te.getImage();
        if (loadImage >= 0) {
            for (int j = 0; j < MTConfig.MAGIC_CIRCLES.size(); ++j) {
                ClientImageDownloadUtil.download("circle" + j, MTConfig.MAGIC_CIRCLES.get(j), false);
            }
            if (loadImage < ClientImageDownloadUtil.lst.size()) {
                try {
                    type = MahoujinRenderType.createMahoujinRenderType(ClientImageDownloadUtil.lst.get(loadImage), 0, false);
                }
                catch (Exception e) {
                    type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
                }
            } else {
                type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
            }
        } else {
            type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
        }
        int lightmapX = 240;
        int lightmapY = 240;
        if (te.getShowCircle()) {
            IVertexBuilder builder = buffer.getBuffer(type);
            builder.func_227888_a_(positionMatrix, -0.5f * size, 0.0f, -0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            builder.func_227888_a_(positionMatrix, -0.5f * size, 0.0f, 0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            builder.func_227888_a_(positionMatrix, 0.5f * size, 0.0f, 0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            builder.func_227888_a_(positionMatrix, 0.5f * size, 0.0f, -0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        }
        matrix.func_227861_a_(0.0, Math.sin(EffectUtil.toRad(te.getCringangle())) / 2.0 * (double)te.getHeight(), 0.0);
        loadImage = te.getRunes();
        if (te.getShowRing()) {
            if (loadImage >= 0) {
                for (int j = 0; j < MTConfig.MAGIC_RUNES.size(); ++j) {
                    ClientImageDownloadUtil.download("runes" + j, MTConfig.MAGIC_RUNES.get(j), true);
                }
                if (loadImage < ClientImageDownloadUtil.lstRunes.size()) {
                    try {
                        type = MahoujinRenderType.createRunesRenderType(ClientImageDownloadUtil.lstRunes.get(loadImage), rindex++);
                    }
                    catch (Exception e) {
                        type = MahoujinRenderType.createRunesRenderType(runes, rindex++);
                    }
                } else {
                    type = MahoujinRenderType.createRunesRenderType(runes, rindex++);
                }
            } else {
                type = MahoujinRenderType.createRunesRenderType(runes, rindex++);
            }
            MahoujinProjectorRenderer.renderRing(positionMatrix, 0.0, ring, size / 2.0f + 0.125f, te.getHeight(), 128, buffer, lightmapX, lightmapY, r, g, b, a, type);
        }
        matrix.func_227865_b_();
    }

    public static void renderRing(Matrix4f matrix4f, double cy, float flatness, float radius, float height, int num_segments, IRenderTypeBuffer buf, int lx, int ly, float r, float g, float b, float a, RenderType rt) {
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        IVertexBuilder buffer = buf.getBuffer(rt);
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                buffer.func_227888_a_(matrix4f, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            buffer.func_227888_a_(matrix4f, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(texx, 0.0f).func_225587_b_(lx, ly).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(texx, 1.0f).func_225587_b_(lx, ly).func_227885_a_(r, g, b, a).func_181675_d();
        }
    }

    public boolean shouldRenderOffScreen(MahoujinProjectorTileEntity te) {
        return true;
    }
}

