/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TranslationTextComponent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.gui.MahoujinHUD;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MahouGui {
    public static void manaText() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String preText = "Mahou";
        int color = 0xDDDDFF;
        IMahou mahou = Utils.getPlayerMahou((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (mahou != null && mahou.hasMagic() && mahou.getVisible()) {
            int storedMana = mahou.getStoredMana();
            int maxMana = mahou.getMaxMana();
            fr.func_238405_a_(new MatrixStack(), preText + " " + storedMana + " / " + maxMana, (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y, color);
            MahouGui.infoOverlay(mahou, 0, fr, color);
        }
        MahouGui.circuitOverlay(fr, preText, color);
    }

    public static void infoOverlay(IMahou mahou, int dist, FontRenderer fr, int color) {
        if (mahou.getDeathCollectionUsesLeft() > 0.0f) {
            String souls = I18n.func_135052_a((String)"mahoutsukai.souls.collected", (Object[])new Object[0]);
            String drain = I18n.func_135052_a((String)"mahoutsukai.souls.drain", (Object[])new Object[0]);
            double mdrain = (double)mahou.getDeathCollectionUsesLeft() * MTConfig.DEATH_COLLECTION_DRAIN_PER_SOUL;
            String manadrain = String.format("%.2f", mdrain);
            fr.func_238405_a_(new MatrixStack(), souls + " " + mahou.getDeathCollectionUsesLeft() + " (-" + manadrain + " " + drain + ")", (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, (float)(MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12)), color);
        }
        if (mahou.getDamageExchangeUses() > 0) {
            String damageExchange = I18n.func_135052_a((String)"mahoutsukai.damage_exchange.count", (Object[])new Object[0]);
            fr.func_238405_a_(new MatrixStack(), damageExchange + " " + mahou.getDamageExchangeUses(), (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, (float)(MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12)), color);
        }
        if (mahou.getImmunityDamageType() != null && EffectUtil.hasBuff((LivingEntity)Minecraft.func_71410_x().field_71439_g, ModEffects.IMMUNITY_EXCHANGE)) {
            String immunityExchange = I18n.func_135052_a((String)"mahoutsukai.immunity_exchange.last", (Object[])new Object[0]);
            fr.func_238405_a_(new MatrixStack(), immunityExchange + " " + mahou.getImmunityDamageType(), (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, (float)(MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12)), color);
        }
    }

    public static void mahoujinOverlay() {
        MahoujinTileEntity mte;
        TileEntity te;
        BlockRayTraceResult bresult;
        BlockPos pos;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        if (result != null && player != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && (pos = (bresult = (BlockRayTraceResult)result).func_216350_a()) != null && (te = player.field_70170_p.func_175625_s(pos)) instanceof MahoujinTileEntity && ((mte = (MahoujinTileEntity)te).getCatalysts() == null || mte.getCatalysts().size() == 0) && player.func_184614_ca().func_190926_b()) {
            MahoujinHUD.renderHUD(Minecraft.func_71410_x());
        }
    }

    public static void circuitOverlay(FontRenderer fr, String preText, int color) {
        TileEntity te;
        BlockRayTraceResult bresult;
        BlockPos pos;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        if (result != null && player != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && (pos = (bresult = (BlockRayTraceResult)result).func_216350_a()) != null && (te = player.field_70170_p.func_175625_s(pos)) instanceof ManaCircuitTileEntity) {
            String s;
            ManaCircuitTileEntity mte = (ManaCircuitTileEntity)te;
            int xc = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2;
            int yc = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 + 8;
            if (mte.isRedstoneOn()) {
                s = new TranslationTextComponent("mahoutsukai.circuit.poweredon").getString();
                fr.func_238405_a_(new MatrixStack(), s, (float)(xc - 30), (float)yc, color);
            } else {
                s = new TranslationTextComponent("mahoutsukai.circuit.poweredoff").getString();
                fr.func_238405_a_(new MatrixStack(), s, (float)(xc - 30), (float)yc, color);
            }
            fr.func_238405_a_(new MatrixStack(), preText + " " + mte.getMana() + " / " + mte.getMaxMana(), (float)(xc - 30), (float)(yc + 14), color);
            if (player.func_110124_au().equals(mte.getOwnerUUID())) {
                s = new TranslationTextComponent("mahoutsukai.circuit.yours").getString();
                fr.func_238405_a_(new MatrixStack(), s, (float)(xc - 30), (float)(yc + 28), color);
            } else {
                s = new TranslationTextComponent("mahoutsukai.circuit.notyours").getString();
                fr.func_238405_a_(new MatrixStack(), s, (float)(xc - 30), (float)(yc + 28), color);
            }
            if (mte.getFae()) {
                s = new TranslationTextComponent("mahoutsukai.circuit.fae_open").getString();
                fr.func_238405_a_(new MatrixStack(), s, (float)(xc - 30), (float)(yc + 42), color);
            } else {
                s = new TranslationTextComponent("mahoutsukai.circuit.fae_closed").getString();
                fr.func_238405_a_(new MatrixStack(), s, (float)(xc - 30), (float)(yc + 42), color);
            }
        }
    }
}

