/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import stepsword.mahoutsukai.entity.mahoujin.BeamProjectileEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderBeamProjectileEntity
extends EntityRenderer<BeamProjectileEntity> {
    public RenderBeamProjectileEntity(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(BeamProjectileEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(BeamProjectileEntity entity, float eyaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
    }

    public static void renderBeamProjectile(BeamProjectileEntity entity, double x, double y, double z, MatrixStack matrix, float partialTicks) {
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        float r2 = colors[4];
        float g2 = colors[5];
        float b2 = colors[6];
        float a2 = colors[7];
        float radius = entity.getRadius();
        float length = entity.getLength();
        matrix.func_227860_a_();
        matrix.func_227861_a_(x, y, z);
        RenderUtils.rotateQ(entity.getRotationYaw(), 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(entity.getRotationPitch(), 1.0f, 0.0f, 0.0f, matrix);
        CullWrappedRenderLayer sphere1 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 0));
        CullWrappedRenderLayer sphere2 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 1));
        CullWrappedRenderLayer sphere3 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 2));
        CullWrappedRenderLayer sphere4 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 3));
        CullWrappedRenderLayer beam1 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(RenderUtils.beam, 4));
        CullWrappedRenderLayer beam2 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(RenderUtils.beam, 5));
        IRenderTypeBuffer.Impl buf = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        float buffer = 0.02f;
        float factor = Math.max(4.0f, 4.0f * length * length);
        matrix.func_227862_a_(1.0f, factor, 1.0f);
        RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, radius - buffer, 32, 240, 240, r2, g2, b2, a2, sphere1, 0.52f);
        matrix.func_227861_a_(0.0, (double)(-length / factor), 0.0);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, radius - buffer, 32, 240, 240, r2, g2, b2, a2, sphere3, 0.52f);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        matrix.func_227861_a_(0.0, (double)(length / factor), 0.0);
        matrix.func_227862_a_(1.0f, 1.0f / factor, 1.0f);
        RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, Math.max(0.0f, radius - buffer), length, 64, 240, 240, r2, g2, b2, a2, beam1);
        RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, radius, length, 64, 240, 240, r, g, b, a, beam2);
        matrix.func_227862_a_(1.0f, factor, 1.0f);
        RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, radius, 32, 240, 240, r, g, b, a, sphere2, 0.52f);
        matrix.func_227861_a_(0.0, (double)(-length / factor), 0.0);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, radius, 32, 240, 240, r, g, b, a, sphere4, 0.52f);
        buf.func_228462_a_((RenderType)sphere1);
        buf.func_228462_a_((RenderType)sphere3);
        buf.func_228462_a_((RenderType)beam1);
        buf.func_228462_a_((RenderType)beam2);
        buf.func_228462_a_((RenderType)sphere4);
        buf.func_228462_a_((RenderType)sphere2);
        matrix.func_227865_b_();
    }
}

